/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.common.impl;

import org.apache.gobblin.config.store.api.ConfigKeyPath;

public class SingleLinkedListConfigKeyPath
implements ConfigKeyPath {
    public static final String PATH_DELIMETER = "/";
    public static final SingleLinkedListConfigKeyPath ROOT = new SingleLinkedListConfigKeyPath(null, "");
    private final ConfigKeyPath parent;
    private final String ownName;

    private SingleLinkedListConfigKeyPath(ConfigKeyPath parent, String name) {
        this.parent = parent;
        this.ownName = name;
    }

    @Override
    public ConfigKeyPath getParent() {
        if (this.isRootPath()) {
            throw new UnsupportedOperationException("Can not getParent from Root");
        }
        return this.parent;
    }

    @Override
    public String getOwnPathName() {
        return this.ownName;
    }

    @Override
    public ConfigKeyPath createChild(String childPathName) {
        if (childPathName == null || childPathName.length() == 0 || childPathName.indexOf(PATH_DELIMETER) >= 0) {
            throw new IllegalArgumentException(String.format("Name \"%s\" can not be null/empty string and can not contains the delimiter \"%s\"", childPathName, PATH_DELIMETER));
        }
        return new SingleLinkedListConfigKeyPath(this, childPathName);
    }

    @Override
    public String getAbsolutePathString() {
        if (this.isRootPath()) {
            return this.getOwnPathName() + PATH_DELIMETER;
        }
        if (this.parent.isRootPath()) {
            return this.parent.getAbsolutePathString() + this.ownName;
        }
        return this.parent.getAbsolutePathString() + PATH_DELIMETER + this.ownName;
    }

    @Override
    public boolean isRootPath() {
        return this == ROOT;
    }

    public String toString() {
        return this.getAbsolutePathString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ownName == null ? 0 : this.ownName.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleLinkedListConfigKeyPath other = (SingleLinkedListConfigKeyPath)obj;
        if (this.ownName == null ? other.ownName != null : !this.ownName.equals(other.ownName)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }
}

