/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.store.api;

import java.net.URI;
import org.apache.gobblin.annotation.Alpha;

@Alpha
public class VersionDoesNotExistException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE_FORMAT = "Failed to find the version %s in config store %s because of: %s ";
    private final URI storeURI;
    private final String configVersion;

    public VersionDoesNotExistException(URI storeURI, String configVersion, String errorMessage) {
        super(String.format(MESSAGE_FORMAT, configVersion, storeURI, errorMessage));
        this.storeURI = storeURI;
        this.configVersion = configVersion;
    }

    public VersionDoesNotExistException(URI storeURI, String configVersion, Exception e) {
        super(String.format(MESSAGE_FORMAT, configVersion, storeURI, e.getMessage()), e);
        this.storeURI = storeURI;
        this.configVersion = configVersion;
    }

    public URI getStoreURI() {
        return this.storeURI;
    }

    public String getConfigVersion() {
        return this.configVersion;
    }
}

