/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.store.deploy;

import lombok.NonNull;
import org.apache.gobblin.config.store.deploy.DeployableConfigSource;
import org.apache.gobblin.config.store.deploy.DeploymentConfig;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;

public class FsDeploymentConfig
extends DeploymentConfig {
    public static final FsPermission DEFAULT_STORE_PERMISSIONS = new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.READ_EXECUTE);
    private final FsPermission storePermissions;

    public FsDeploymentConfig(@NonNull DeployableConfigSource deployableConfigSource, @NonNull String version, @NonNull FsPermission storePermissions) {
        super(deployableConfigSource, version);
        if (deployableConfigSource == null) {
            throw new NullPointerException("deployableConfigSource");
        }
        if (version == null) {
            throw new NullPointerException("version");
        }
        if (storePermissions == null) {
            throw new NullPointerException("storePermissions");
        }
        this.storePermissions = storePermissions;
    }

    public FsDeploymentConfig(DeployableConfigSource deployableConfigSource, String version) {
        this(deployableConfigSource, version, DEFAULT_STORE_PERMISSIONS);
    }

    public FsPermission getStorePermissions() {
        return this.storePermissions;
    }

    @Override
    public String toString() {
        return "FsDeploymentConfig(storePermissions=" + this.getStorePermissions() + ")";
    }
}

