/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import org.apache.hadoop.hive.metastore.api.CompactionType;

public class CompactionInfo {
    public long id;
    public String dbname;
    public String tableName;
    public String partName;
    public CompactionType type;
    public String runAs;
    public boolean tooManyAborts = false;
    private String fullPartitionName = null;
    private String fullTableName = null;

    public CompactionInfo(String dbname, String tableName, String partName, CompactionType type) {
        this.dbname = dbname;
        this.tableName = tableName;
        this.partName = partName;
        this.type = type;
    }

    CompactionInfo() {
    }

    public String getFullPartitionName() {
        if (this.fullPartitionName == null) {
            StringBuilder buf = new StringBuilder(this.dbname);
            buf.append('.');
            buf.append(this.tableName);
            if (this.partName != null) {
                buf.append('.');
                buf.append(this.partName);
            }
            this.fullPartitionName = buf.toString();
        }
        return this.fullPartitionName;
    }

    public String getFullTableName() {
        if (this.fullTableName == null) {
            StringBuilder buf = new StringBuilder(this.dbname);
            buf.append('.');
            buf.append(this.tableName);
            this.fullTableName = buf.toString();
        }
        return this.fullTableName;
    }

    public boolean isMajorCompaction() {
        return CompactionType.MAJOR == this.type;
    }
}

