/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.tool;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import kafka.message.MessageAndMetadata;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.kafka.schemareg.KafkaSchemaRegistry;
import org.apache.gobblin.kafka.schemareg.KafkaSchemaRegistryFactory;
import org.apache.gobblin.kafka.serialize.LiAvroDeserializer;
import org.apache.gobblin.kafka.serialize.MD5Digest;
import org.apache.gobblin.kafka.tool.KafkaCheckpoint;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleKafkaConsumer {
    private static final Logger log = LoggerFactory.getLogger(SimpleKafkaConsumer.class);
    private final ConsumerConnector consumer;
    private final KafkaStream<byte[], byte[]> stream;
    private final ConsumerIterator<byte[], byte[]> iterator;
    private final String topic;
    private final KafkaSchemaRegistry<MD5Digest, Schema> schemaRegistry;
    private final Deserializer deserializer;

    public SimpleKafkaConsumer(Properties props, KafkaCheckpoint checkpoint) {
        Config config = ConfigFactory.parseProperties((Properties)props);
        this.topic = config.getString("topic");
        String zkConnect = config.getString("zookeeper.connect");
        this.schemaRegistry = KafkaSchemaRegistryFactory.getSchemaRegistry((Properties)props);
        this.deserializer = new LiAvroDeserializer(this.schemaRegistry);
        Properties consumeProps = new Properties();
        consumeProps.put("zookeeper.connect", zkConnect);
        consumeProps.put("group.id", "gobblin-tool-" + System.nanoTime());
        consumeProps.put("zookeeper.session.timeout.ms", "10000");
        consumeProps.put("zookeeper.sync.time.ms", "10000");
        consumeProps.put("auto.commit.interval.ms", "10000");
        consumeProps.put("auto.offset.reset", "smallest");
        consumeProps.put("auto.commit.enable", "false");
        this.consumer = Consumer.createJavaConsumerConnector((ConsumerConfig)new ConsumerConfig(consumeProps));
        Map consumerMap = this.consumer.createMessageStreams((Map)ImmutableMap.of((Object)this.topic, (Object)1));
        List streams = (List)consumerMap.get(this.topic);
        this.stream = (KafkaStream)streams.get(0);
        this.iterator = this.stream.iterator();
    }

    public void close() {
        this.consumer.shutdown();
    }

    public void shutdown() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        File checkpointFile;
        KafkaCheckpoint checkpoint;
        Properties props;
        block8: {
            Preconditions.checkArgument((args.length >= 1 ? 1 : 0) != 0, (Object)("Usage: java " + SimpleKafkaConsumer.class.getName() + " <properties_file> <checkpoint_file>"));
            String fileName = args[0];
            props = new Properties();
            props.load(new FileInputStream(new File(fileName)));
            checkpoint = KafkaCheckpoint.emptyCheckpoint();
            checkpointFile = null;
            if (args.length > 1) {
                try {
                    checkpointFile = new File(args[1]);
                    if (checkpointFile.exists()) {
                        try (FileInputStream fis = null;){
                            fis = new FileInputStream(checkpointFile);
                            checkpoint = KafkaCheckpoint.deserialize(fis);
                            break block8;
                        }
                    }
                    log.info("Checkpoint doesn't exist, we will start with an empty one and store it here.");
                }
                catch (IOException e) {
                    log.warn("Could not deserialize the previous checkpoint. Starting with empty", (Throwable)e);
                    if (checkpoint.isEmpty()) break block8;
                    checkpoint = KafkaCheckpoint.emptyCheckpoint();
                }
            }
        }
        final SimpleKafkaConsumer consumer = new SimpleKafkaConsumer(props, checkpoint);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("Shutting down...");
                consumer.shutdown();
            }
        });
        consumer.printLoop(checkpoint, checkpointFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printLoop(KafkaCheckpoint checkpoint, File checkpointFile) throws IOException {
        boolean newFileCreated;
        boolean storeCheckpoints;
        boolean bl = storeCheckpoints = checkpointFile != null;
        if (storeCheckpoints && (newFileCreated = checkpointFile.createNewFile())) {
            log.info("Created new checkpoint file: " + checkpointFile.getAbsolutePath());
        }
        while (true) {
            try {
                if (!this.iterator.hasNext()) {
                    return;
                }
                MessageAndMetadata messagePlusMeta = this.iterator.next();
                if (messagePlusMeta == null) continue;
                byte[] payload = (byte[])messagePlusMeta.message();
                System.out.println("Got a message of size " + payload.length + " bytes");
                GenericRecord record = (GenericRecord)this.deserializer.deserialize(this.topic, payload);
                System.out.println(record.toString());
                checkpoint.update(messagePlusMeta.partition(), messagePlusMeta.offset());
                continue;
            }
            catch (RuntimeException e) {
                log.warn("Error detected", (Throwable)e);
                continue;
            }
            finally {
                if (!storeCheckpoints || checkpoint == KafkaCheckpoint.emptyCheckpoint()) continue;
                System.out.println("Storing checkpoint to file: " + checkpointFile.getAbsolutePath());
                KafkaCheckpoint.serialize(checkpoint, checkpointFile);
                continue;
            }
            break;
        }
    }
}

