/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaParserFactory;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PegasusSchemaParser;
import com.linkedin.data.schema.resolver.FileDataSchemaLocation;
import com.linkedin.data.schema.resolver.InJarFileDataSchemaLocation;
import com.linkedin.pegasus.generator.DataSchemaParser;
import com.linkedin.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileFormatDataSchemaParser {
    private final String _resolverPath;
    private final DataSchemaResolver _schemaResolver;
    private final DataSchemaParserFactory _schemaParserFactory;

    public FileFormatDataSchemaParser(String resolverPath, DataSchemaResolver schemaResolver, DataSchemaParserFactory schemaParserFactory) {
        this._resolverPath = resolverPath;
        this._schemaResolver = schemaResolver;
        this._schemaParserFactory = schemaParserFactory;
    }

    public DataSchemaParser.ParseResult parseSources(String[] sources) throws IOException {
        DataSchemaParser.ParseResult result = new DataSchemaParser.ParseResult();
        try {
            for (String source : sources) {
                File sourceFile = new File(source);
                if (sourceFile.exists()) {
                    if (sourceFile.isDirectory()) {
                        FileUtil.FileExtensionFilter filter = new FileUtil.FileExtensionFilter(this._schemaParserFactory.getLanguageExtension());
                        List sourceFilesInDirectory = FileUtil.listFiles((File)sourceFile, (FileFilter)filter);
                        for (File f : sourceFilesInDirectory) {
                            this.parseFile(f, result);
                            result.getSourceFiles().add(f);
                        }
                        continue;
                    }
                    if (sourceFile.getName().endsWith(".jar")) {
                        JarFile jarFile = new JarFile(sourceFile);
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (entry.isDirectory() || !entry.getName().endsWith(this._schemaParserFactory.getLanguageExtension())) continue;
                            this.parseJarEntry(jarFile, entry, result);
                        }
                    } else {
                        this.parseFile(sourceFile, result);
                    }
                    result.getSourceFiles().add(sourceFile);
                    continue;
                }
                StringBuilder errorMessage = new StringBuilder();
                NamedDataSchema schema = this._schemaResolver.findDataSchema(source, errorMessage);
                if (schema == null) {
                    result._messageBuilder.append("File cannot be opened or schema name cannot be resolved: ").append(source).append("\n");
                }
                if (errorMessage.length() <= 0) continue;
                result._messageBuilder.append(errorMessage.toString());
            }
            if (result._messageBuilder.length() > 0) {
                throw new IOException(result.getMessage());
            }
            for (Map.Entry entry : this._schemaResolver.nameToDataSchemaLocations().entrySet()) {
                DataSchema schema = (DataSchema)this._schemaResolver.bindings().get(entry.getKey());
                result.getSchemaAndLocations().put(schema, (DataSchemaLocation)entry.getValue());
            }
            return result;
        }
        catch (RuntimeException e) {
            if (result._messageBuilder.length() > 0) {
                e = new RuntimeException("Unexpected " + e.getClass().getSimpleName() + " encountered.\nThis may be caused by the following parsing or processing errors:\n" + result.getMessage(), e);
            }
            throw e;
        }
    }

    private void parseFile(File schemaSourceFile, DataSchemaParser.ParseResult result) throws IOException {
        DataSchemaLocation location = this.getSchemaLocation(schemaSourceFile);
        if (this._schemaResolver.locationResolved(location)) {
            return;
        }
        SchemaFileInputStream inputStream = new SchemaFileInputStream(schemaSourceFile);
        List<DataSchema> schemas = this.parseSchemaStream(inputStream, location, result);
        for (DataSchema schema : schemas) {
            if (schema instanceof NamedDataSchema) {
                this.validateSchemaWithPath(schemaSourceFile.getAbsolutePath(), (NamedDataSchema)schema);
            }
            result.getSchemaAndLocations().put(schema, location);
        }
    }

    private void parseJarEntry(JarFile schemaJarFile, JarEntry jarEntry, DataSchemaParser.ParseResult result) throws IOException {
        DataSchemaLocation location = this.getSchemaLocation(schemaJarFile, jarEntry.getName());
        if (this._schemaResolver.locationResolved(location)) {
            return;
        }
        InputStream jarStream = schemaJarFile.getInputStream(jarEntry);
        List<DataSchema> schemas = this.parseSchemaStream(jarStream, location, result);
        for (DataSchema schema : schemas) {
            if (schema instanceof NamedDataSchema) {
                this.validateSchemaWithPath(location.toString(), (NamedDataSchema)schema);
            }
            result.getSchemaAndLocations().put(schema, location);
        }
    }

    private DataSchemaLocation getSchemaLocation(File schemaFile) {
        return new FileDataSchemaLocation(schemaFile);
    }

    private DataSchemaLocation getSchemaLocation(JarFile jarFile, String pathInJar) {
        return new InJarFileDataSchemaLocation(jarFile, pathInJar);
    }

    private void validateSchemaWithPath(String path, NamedDataSchema namedDataSchema) {
        String namespace = namedDataSchema.getNamespace();
        if (!FileUtil.removeFileExtension((String)path.substring(path.lastIndexOf(File.separator) + 1)).equalsIgnoreCase(namedDataSchema.getName())) {
            throw new IllegalArgumentException(namedDataSchema.getFullName() + " has name " + namedDataSchema.getName() + " that does not match path '" + path + "' -- " + path.substring(path.lastIndexOf(File.separator) + 1));
        }
        String parent = path.substring(0, path.lastIndexOf(File.separator));
        if (!parent.endsWith(namespace.replace('.', File.separatorChar))) {
            throw new IllegalArgumentException(namedDataSchema.getFullName() + " has namespace that does not match parent path '" + parent + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataSchema> parseSchemaStream(InputStream schemaInputStream, DataSchemaLocation schemaLocation, DataSchemaParser.ParseResult result) throws IOException {
        PegasusSchemaParser parser = this._schemaParserFactory.create(this._schemaResolver);
        try {
            parser.setLocation(schemaLocation);
            parser.parse(schemaInputStream);
            if (parser.hasError()) {
                List<DataSchema> list = Collections.emptyList();
                return list;
            }
            List list = parser.topLevelDataSchemas();
            return list;
        }
        finally {
            schemaInputStream.close();
            if (parser.hasError()) {
                result._messageBuilder.append(schemaLocation.toString()).append(",").append(parser.errorMessage());
            }
        }
    }

    private static class SchemaFileInputStream
    extends FileInputStream {
        private File _schemaSourceFile;

        private SchemaFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this._schemaSourceFile = file;
        }

        public String toString() {
            return this._schemaSourceFile.toString();
        }
    }
}

