/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.WrappingMapTemplate;
import com.linkedin.restli.common.TypeSpec;
import java.util.Arrays;
import java.util.Map;

public class BatchRequest<T extends RecordTemplate>
extends RecordTemplate {
    public static final String ENTITIES = "entities";
    private final TypeSpec<T> _valueType;
    private final MapDataSchema _entitiesSchema;
    private final RecordDataSchema.Field _entitiesField;
    private final RecordDataSchema _schema;
    private static final Name _BATCH_REQUEST_NAME = new Name(BatchRequest.class.getSimpleName());

    public BatchRequest(DataMap data, Class<T> valueClass) {
        this(data, new TypeSpec<T>(valueClass));
    }

    private BatchRequest(DataMap data, Class<T> valueClass, int capacity) {
        this(data, new TypeSpec<T>(valueClass), capacity);
    }

    public BatchRequest(DataMap data, TypeSpec<T> valueType) {
        this(data, valueType, 0);
    }

    private BatchRequest(DataMap data, TypeSpec<T> valueType, int capacity) {
        super(data, null);
        this._valueType = valueType;
        StringBuilder errorMessageBuilder = new StringBuilder(10);
        Name elementSchemaName = new Name(valueType.getType().getSimpleName());
        this._entitiesSchema = new MapDataSchema((DataSchema)new RecordDataSchema(elementSchemaName, RecordDataSchema.RecordType.RECORD));
        this._entitiesField = new RecordDataSchema.Field((DataSchema)this._entitiesSchema);
        this._entitiesField.setName(ENTITIES, errorMessageBuilder);
        if (this.data().get((Object)ENTITIES) == null) {
            this.data().put((Object)ENTITIES, (Object)new DataMap(capacity));
        }
        this._schema = new RecordDataSchema(_BATCH_REQUEST_NAME, RecordDataSchema.RecordType.RECORD);
        this._schema.setFields(Arrays.asList(this._entitiesField), errorMessageBuilder);
    }

    public RecordDataSchema schema() {
        return this._schema;
    }

    public Map<String, T> getEntities() {
        DataMap value = this.data().getDataMap(ENTITIES);
        return new DynamicRecordMap<T>(value, this._entitiesSchema, this._valueType.getType());
    }

    private static class DynamicRecordMap<R extends RecordTemplate>
    extends WrappingMapTemplate<R> {
        public DynamicRecordMap(DataMap map, MapDataSchema mapSchema, Class<R> valueClass) {
            super(map, mapSchema, valueClass);
        }
    }
}

