/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.WrappingArrayTemplate;
import java.util.Arrays;
import java.util.List;

public class CollectionRequest<T extends RecordTemplate>
extends RecordTemplate {
    public static final String ELEMENTS = "elements";
    private final Class<T> _elementClass;
    private final ArrayDataSchema _arraySchema;
    private final RecordDataSchema.Field _arrayField;
    private final RecordDataSchema _schema;
    private static final Name _COLLECTION_REQUEST_NAME = new Name(CollectionRequest.class.getSimpleName());
    private DynamicRecordArray<T> _templatedCollection;

    public CollectionRequest(Class<T> elementClass) {
        this(new DataMap(), elementClass);
    }

    public CollectionRequest(DataMap data, Class<T> elementClass) {
        super(data, null);
        this._elementClass = elementClass;
        StringBuilder errorMessageBuilder = new StringBuilder(10);
        Name elementSchemaName = new Name(elementClass.getSimpleName());
        this._arraySchema = new ArrayDataSchema((DataSchema)new RecordDataSchema(elementSchemaName, RecordDataSchema.RecordType.RECORD));
        this._arrayField = new RecordDataSchema.Field((DataSchema)this._arraySchema);
        this._arrayField.setName(ELEMENTS, errorMessageBuilder);
        if (this.data().get((Object)ELEMENTS) == null) {
            this.data().put((Object)ELEMENTS, (Object)new DataList());
        }
        this._schema = new RecordDataSchema(_COLLECTION_REQUEST_NAME, RecordDataSchema.RecordType.RECORD);
        this._schema.setFields(Arrays.asList(this._arrayField), errorMessageBuilder);
    }

    public RecordDataSchema schema() {
        return this._schema;
    }

    public List<T> getElements() {
        if (this._templatedCollection == null) {
            DataList value = (DataList)this.data().get((Object)ELEMENTS);
            this._templatedCollection = new DynamicRecordArray<T>(value, this._arraySchema, this._elementClass);
        }
        return this._templatedCollection;
    }

    private static class DynamicRecordArray<R extends RecordTemplate>
    extends WrappingArrayTemplate<R> {
        public DynamicRecordArray(DataList list, ArrayDataSchema arraySchema, Class<R> elementClass) {
            super(list, arraySchema, elementClass);
        }
    }
}

