/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.TypeSpec;

public class ComplexKeySpec<KK extends RecordTemplate, KP extends RecordTemplate> {
    private final TypeSpec<KK> _keyType;
    private final TypeSpec<KP> _paramsType;

    public static <KK extends RecordTemplate, KP extends RecordTemplate> ComplexKeySpec<KK, KP> forClassesMaybeNull(Class<KK> keyKeyClass, Class<KP> keyParamsClass) {
        if (keyKeyClass == null) {
            return null;
        }
        if (keyParamsClass == null) {
            throw new IllegalArgumentException("keyParamsClass must be non-null.");
        }
        return new ComplexKeySpec<KK, KP>(new TypeSpec<KK>(keyKeyClass), new TypeSpec<KP>(keyParamsClass));
    }

    public ComplexKeySpec(TypeSpec<KK> keyType, TypeSpec<KP> paramsType) {
        if (keyType == null) {
            throw new IllegalArgumentException("keyType must be non-null.");
        }
        if (paramsType == null) {
            throw new IllegalArgumentException("paramsType must be non-null.");
        }
        this._keyType = keyType;
        this._paramsType = paramsType;
    }

    public TypeSpec<KK> getKeyType() {
        return this._keyType;
    }

    public TypeSpec<KP> getParamsType() {
        return this._paramsType;
    }

    public String toString() {
        return "ComplexKeySpec{\n  _keyType=" + this._keyType + ",\n  _paramsType=" + this._paramsType + "\n}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComplexKeySpec)) {
            return false;
        }
        ComplexKeySpec that = (ComplexKeySpec)o;
        if (!this._keyType.equals(that._keyType)) {
            return false;
        }
        return !(this._paramsType != null ? !this._paramsType.equals(that._paramsType) : that._paramsType != null);
    }

    public int hashCode() {
        int result = this._keyType.hashCode();
        result = 31 * result + (this._paramsType != null ? this._paramsType.hashCode() : 0);
        return result;
    }
}

