/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.jersey.api.uri.UriComponent;
import com.linkedin.jersey.core.util.MultivaluedMap;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.PathSegment;
import com.linkedin.restli.internal.common.QueryParamsDataMap;
import com.linkedin.restli.internal.common.URIElementParser;
import com.linkedin.restli.internal.common.URLEscaper;
import java.net.URI;
import java.util.List;
import java.util.Map;

public final class ComplexResourceKey<K extends RecordTemplate, P extends RecordTemplate> {
    protected final K key;
    protected final P params;
    private static final String COMPLEX_KEY_PARAMS = "$params";

    public ComplexResourceKey(K key, P params) {
        if (key == null || key.data() == null) {
            throw new IllegalArgumentException("Key part of the complex resource key is required");
        }
        if (params != null && params.data() == null) {
            throw new IllegalArgumentException("Params part of the complex resource key has a null internal data map");
        }
        this.key = key;
        this.params = params;
    }

    public K getKey() {
        return this.key;
    }

    public P getParams() {
        return this.params;
    }

    @Deprecated
    public String toString() {
        return this.toString(URLEscaper.Escaping.NO_ESCAPING);
    }

    @Deprecated
    public String toString(URLEscaper.Escaping escaping) {
        return QueryParamsDataMap.dataMapToQueryString(this.key.data(), escaping);
    }

    @Deprecated
    public String toStringFull() {
        return this.toStringFull(URLEscaper.Escaping.NO_ESCAPING);
    }

    @Deprecated
    public String toStringFull(URLEscaper.Escaping escaping) {
        return QueryParamsDataMap.dataMapToQueryString(this.toDataMap(), escaping);
    }

    public DataMap toDataMap() {
        DataMap m = new DataMap((Map)this.key.data());
        if (this.params != null) {
            m.put((Object)COMPLEX_KEY_PARAMS, (Object)this.params.data());
        }
        return m;
    }

    public boolean isReadOnly() {
        boolean result = true;
        result = this.key.data().isReadOnly();
        if (this.params != null) {
            result &= this.params.data().isReadOnly();
        }
        return result;
    }

    public void makeReadOnly() {
        this.key.data().makeReadOnly();
        if (this.params != null) {
            this.params.data().makeReadOnly();
        }
    }

    public static ComplexResourceKey<RecordTemplate, RecordTemplate> buildFromDataMap(DataMap keyDataMap, Class<? extends RecordTemplate> keyKeyClass, Class<? extends RecordTemplate> keyParamsClass) {
        return ComplexResourceKey.buildFromDataMap(keyDataMap, ComplexKeySpec.forClassesMaybeNull(keyKeyClass, keyParamsClass));
    }

    public static ComplexResourceKey<RecordTemplate, RecordTemplate> buildFromDataMap(DataMap keyDataMap, ComplexKeySpec<?, ?> complexKeyType) {
        DataMap paramsDataMap = (DataMap)(keyDataMap = new DataMap((Map)keyDataMap)).remove((Object)COMPLEX_KEY_PARAMS);
        if (paramsDataMap == null) {
            paramsDataMap = new DataMap();
        }
        RecordTemplate key = ComplexResourceKey.validateDataMap(keyDataMap, complexKeyType.getKeyType());
        RecordTemplate params = ComplexResourceKey.validateDataMap(paramsDataMap, complexKeyType.getParamsType());
        return new ComplexResourceKey<RecordTemplate, RecordTemplate>(key, params);
    }

    @Deprecated
    public static ComplexResourceKey<RecordTemplate, RecordTemplate> parseFromPathSegment(String currentPathSegment, Class<? extends RecordTemplate> keyKeyClass, Class<? extends RecordTemplate> keyParamsClass) throws PathSegment.PathSegmentSyntaxException {
        return ComplexResourceKey.parseFromPathSegment(currentPathSegment, ComplexKeySpec.forClassesMaybeNull(keyKeyClass, keyParamsClass));
    }

    @Deprecated
    public static ComplexResourceKey<RecordTemplate, RecordTemplate> parseFromPathSegment(String currentPathSegment, ComplexKeySpec<?, ?> complexKeyType) throws PathSegment.PathSegmentSyntaxException {
        MultivaluedMap queryParameters = UriComponent.decodeQuery((URI)URI.create("?" + currentPathSegment), (boolean)true);
        DataMap allParametersDataMap = QueryParamsDataMap.parseDataMapKeys((Map<String, List<String>>)queryParameters);
        return ComplexResourceKey.buildFromDataMap(allParametersDataMap, complexKeyType);
    }

    public static ComplexResourceKey<RecordTemplate, RecordTemplate> parseString(String str, Class<? extends RecordTemplate> keyKeyClass, Class<? extends RecordTemplate> keyParamsClass, ProtocolVersion version) throws PathSegment.PathSegmentSyntaxException {
        return ComplexResourceKey.parseString(str, ComplexKeySpec.forClassesMaybeNull(keyKeyClass, keyParamsClass), version);
    }

    public static ComplexResourceKey<RecordTemplate, RecordTemplate> parseString(String str, ComplexKeySpec<?, ?> complexKeyType, ProtocolVersion version) throws PathSegment.PathSegmentSyntaxException {
        if (version.compareTo(AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) >= 0) {
            DataMap dataMap = (DataMap)URIElementParser.parse(str);
            return ComplexResourceKey.buildFromDataMap(dataMap, complexKeyType);
        }
        return ComplexResourceKey.parseFromPathSegment(str, complexKeyType);
    }

    private static RecordTemplate validateDataMap(DataMap dataMap, TypeSpec<? extends RecordTemplate> spec) {
        RecordTemplate recordTemplate = ComplexResourceKey.wrapWithSchema(dataMap, spec);
        ValidateDataAgainstSchema.validate((Object)recordTemplate.data(), (DataSchema)recordTemplate.schema(), (ValidationOptions)new ValidationOptions(RequiredMode.CAN_BE_ABSENT_IF_HAS_DEFAULT, CoercionMode.STRING_TO_PRIMITIVE));
        return recordTemplate;
    }

    private static RecordTemplate wrapWithSchema(DataMap dataMap, TypeSpec<? extends RecordTemplate> spec) {
        Class<? extends RecordTemplate> clazz = spec.getType();
        return (RecordTemplate)DataTemplateUtil.wrap((Object)dataMap, clazz);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexResourceKey other = (ComplexResourceKey)obj;
        return this.key.equals(other.key) && (this.params == null ? other.params == null : this.params.equals(other.params));
    }

    public ComplexResourceKey<K, P> copy() throws CloneNotSupportedException {
        RecordTemplate copyKey = this.key.copy();
        RecordTemplate copyParams = null;
        if (this.params != null) {
            copyParams = this.params.copy();
        }
        return new ComplexResourceKey<RecordTemplate, RecordTemplate>(copyKey, copyParams);
    }
}

