/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.internal.common.ValueConverter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CompoundKey {
    private final Map<String, Object> _keys;
    private boolean _isReadOnly;

    public CompoundKey() {
        this._keys = new HashMap<String, Object>(4);
        this._isReadOnly = false;
    }

    private CompoundKey(CompoundKey compoundKey) {
        this._keys = new HashMap<String, Object>(compoundKey._keys);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CompoundKey fromValues(DataMap fieldValues, Map<String, TypeInfo> fieldTypes) {
        CompoundKey result = new CompoundKey();
        for (Map.Entry entry : fieldValues.entrySet()) {
            void var9_13;
            Class<?> declaredType;
            TypeInfo fieldType = fieldTypes.get(entry.getKey());
            TypeInfo typeInfo = fieldType;
            DataSchema declaredSchema = typeInfo.getDeclared().getSchema();
            if (declaredSchema.getType() == DataSchema.Type.TYPEREF) {
                if (declaredSchema.getDereferencedDataSchema().isPrimitive()) {
                    declaredType = DataSchemaUtil.dataSchemaTypeToPrimitiveDataSchemaClass((DataSchema.Type)declaredSchema.getDereferencedType());
                } else {
                    if (declaredSchema.getDereferencedType() != DataSchema.Type.ENUM) throw new IllegalArgumentException("Compound key type must dereference to a primitive type or enum.");
                    try {
                        declaredType = Class.forName(((EnumDataSchema)declaredSchema.getDereferencedDataSchema()).getFullName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new RuntimeException(classNotFoundException);
                    }
                }
            } else {
                declaredType = typeInfo.getDeclaredType();
            }
            Object v = entry.getValue();
            if (!v.getClass().equals(declaredType)) {
                if (!v.getClass().equals(String.class)) throw new IllegalArgumentException("Value " + v + " is not a String or an object of " + declaredType.getSimpleName());
                Object object = ValueConverter.coerceString((String)v, declaredType);
            }
            Object object = DataTemplateUtil.coerceOutput((Object)var9_13, typeInfo.getBindingType());
            result.append((String)entry.getKey(), object);
        }
        return result;
    }

    public CompoundKey append(String name, Object value) {
        if (this._isReadOnly) {
            throw new UnsupportedOperationException("Can't append to a read only key!");
        }
        if (name == null) {
            throw new IllegalArgumentException("name of CompoundKey part cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value of CompoundKey part cannot be null");
        }
        this._keys.put(name, value);
        return this;
    }

    public Object getPart(String name) {
        return this._keys.get(name);
    }

    public Integer getPartAsInt(String name) {
        return (Integer)this.getPart(name);
    }

    public Long getPartAsLong(String name) {
        return (Long)this.getPart(name);
    }

    public String getPartAsString(String name) {
        return (String)this.getPart(name);
    }

    public int getNumParts() {
        return this._keys.size();
    }

    public Set<String> getPartKeys() {
        return this._keys.keySet();
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void makeReadOnly() {
        this._isReadOnly = true;
    }

    public int hashCode() {
        return this._keys.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Class<?> thatClass = obj.getClass();
        if (!CompoundKey.class.isAssignableFrom(thatClass)) {
            return false;
        }
        CompoundKey other = (CompoundKey)obj;
        return this._keys.equals(other._keys);
    }

    public CompoundKey copy() {
        return new CompoundKey(this);
    }

    public DataMap toDataMap(Map<String, TypeInfo> fieldTypes) {
        DataMap dataMap = new DataMap(this._keys.size());
        for (Map.Entry<String, Object> keyParts : this._keys.entrySet()) {
            String key = keyParts.getKey();
            Object value = keyParts.getValue();
            DataSchema schema = fieldTypes.get(key).getDeclared().getSchema();
            DataSchema dereferencedSchema = schema.getDereferencedDataSchema();
            Class dereferencedClass = DataSchemaUtil.dataSchemaTypeToPrimitiveDataSchemaClass((DataSchema.Type)dereferencedSchema.getType());
            Object coercedInput = DataTemplateUtil.coerceInput((Object)value, value.getClass(), (Class)dereferencedClass);
            dataMap.put((Object)key, coercedInput);
        }
        return dataMap;
    }

    @Deprecated
    public String toString() {
        ArrayList<String> keyList = new ArrayList<String>(this._keys.keySet());
        Collections.sort(keyList);
        StringBuilder b = new StringBuilder();
        boolean delimit = false;
        for (String keyPart : keyList) {
            if (delimit) {
                b.append('&');
            }
            try {
                b.append(URLEncoder.encode(keyPart, "UTF-8"));
                b.append('=');
                b.append(URLEncoder.encode(DataTemplateUtil.stringify((Object)this._keys.get(keyPart)), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UnsupportedEncodingException while trying to encode the key", e);
            }
            delimit = true;
        }
        return b.toString();
    }

    public static final class TypeInfo {
        private final TypeSpec<?> _bindingType;
        private final TypeSpec<?> _declaredType;

        public TypeInfo(Class<?> bindingClass, Class<?> declaredClass) {
            this(new TypeSpec(bindingClass), new TypeSpec(declaredClass));
        }

        public TypeInfo(TypeSpec<?> bindingType, TypeSpec<?> declaredType) {
            this._bindingType = bindingType;
            this._declaredType = declaredType;
        }

        public Class<?> getBindingType() {
            return this._bindingType.getType();
        }

        public Class<?> getDeclaredType() {
            return this._declaredType.getType();
        }

        public TypeSpec<?> getBinding() {
            return this._bindingType;
        }

        public TypeSpec<?> getDeclared() {
            return this._declaredType;
        }
    }
}

