/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.restli.common.HttpMethod;

public enum ResourceMethod {
    GET(HttpMethod.GET),
    BATCH_GET(HttpMethod.GET),
    FINDER(HttpMethod.GET),
    CREATE(HttpMethod.POST),
    BATCH_CREATE(HttpMethod.POST),
    PARTIAL_UPDATE(HttpMethod.POST),
    UPDATE(HttpMethod.PUT),
    BATCH_UPDATE(HttpMethod.PUT),
    DELETE(HttpMethod.DELETE),
    ACTION(HttpMethod.POST),
    BATCH_PARTIAL_UPDATE(HttpMethod.POST),
    BATCH_DELETE(HttpMethod.DELETE),
    GET_ALL(HttpMethod.GET),
    OPTIONS(HttpMethod.OPTIONS);

    private HttpMethod _httpMethod;

    private ResourceMethod(HttpMethod httpMethod) {
        this._httpMethod = httpMethod;
    }

    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static ResourceMethod fromString(String name) {
        return ResourceMethod.valueOf(name.toUpperCase());
    }
}

