/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import com.linkedin.multipart.MultiPartMIMEDataSourceIterator;
import com.linkedin.multipart.MultiPartMIMEDataSourceIteratorCallback;
import com.linkedin.multipart.MultiPartMIMEDataSourceWriter;
import com.linkedin.multipart.MultiPartMIMEWriter;
import com.linkedin.r2.message.stream.entitystream.ByteStringWriter;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.restli.common.attachments.RestLiAttachmentDataSourceWriter;
import com.linkedin.restli.common.attachments.RestLiDataSourceIterator;
import com.linkedin.restli.common.attachments.RestLiDataSourceIteratorCallback;
import java.util.Map;
import java.util.TreeMap;

public class AttachmentUtils {
    public static final String RESTLI_MULTIPART_SUBTYPE = "related";

    public static void appendSingleAttachmentToBuilder(MultiPartMIMEWriter.Builder builder, final RestLiAttachmentDataSourceWriter streamingAttachment) {
        builder.appendDataSource(new MultiPartMIMEDataSourceWriter(){

            public Map<String, String> dataSourceHeaders() {
                TreeMap<String, String> dataSourceHeaders = new TreeMap<String, String>();
                dataSourceHeaders.put("Content-ID", streamingAttachment.getAttachmentID());
                return dataSourceHeaders;
            }

            public void onInit(WriteHandle wh) {
                streamingAttachment.onInit(wh);
            }

            public void onWritePossible() {
                streamingAttachment.onWritePossible();
            }

            public void onAbort(Throwable e) {
                streamingAttachment.onAbort(e);
            }
        });
    }

    public static void appendMultipleAttachmentsToBuilder(MultiPartMIMEWriter.Builder builder, final RestLiDataSourceIterator restLiDataSourceIterator) {
        builder.appendDataSourceIterator(new MultiPartMIMEDataSourceIterator(){

            public void abandonAllDataSources() {
                restLiDataSourceIterator.abandonAllDataSources();
            }

            public void registerDataSourceReaderCallback(final MultiPartMIMEDataSourceIteratorCallback callback) {
                restLiDataSourceIterator.registerDataSourceReaderCallback(new RestLiDataSourceIteratorCallback(){

                    @Override
                    public void onNewDataSourceWriter(final RestLiAttachmentDataSourceWriter dataSourceWriter) {
                        callback.onNewDataSource(new MultiPartMIMEDataSourceWriter(){

                            public Map<String, String> dataSourceHeaders() {
                                TreeMap<String, String> dataSourceHeaders = new TreeMap<String, String>();
                                dataSourceHeaders.put("Content-ID", dataSourceWriter.getAttachmentID());
                                return dataSourceHeaders;
                            }

                            public void onInit(WriteHandle wh) {
                                dataSourceWriter.onInit(wh);
                            }

                            public void onWritePossible() {
                                dataSourceWriter.onWritePossible();
                            }

                            public void onAbort(Throwable e) {
                                dataSourceWriter.onAbort(e);
                            }
                        });
                    }

                    @Override
                    public void onFinished() {
                        callback.onFinished();
                    }

                    @Override
                    public void onAbandonComplete() {
                        callback.onAbandonComplete();
                    }

                    @Override
                    public void onStreamError(Throwable throwable) {
                        callback.onStreamError(throwable);
                    }
                });
            }
        });
    }

    public static MultiPartMIMEWriter createMultiPartMIMEWriter(final ByteStringWriter firstPartWriter, final String firstPartContentType, MultiPartMIMEWriter.Builder streamingAttachments) {
        streamingAttachments.prependDataSource(new MultiPartMIMEDataSourceWriter(){

            public Map<String, String> dataSourceHeaders() {
                TreeMap<String, String> metadataHeaders = new TreeMap<String, String>();
                metadataHeaders.put("Content-Type", firstPartContentType);
                return metadataHeaders;
            }

            public void onInit(WriteHandle wh) {
                firstPartWriter.onInit(wh);
            }

            public void onWritePossible() {
                firstPartWriter.onWritePossible();
            }

            public void onAbort(Throwable e) {
                firstPartWriter.onAbort(e);
            }
        });
        return streamingAttachments.build();
    }
}

