/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.jersey.api.uri.UriBuilder;
import com.linkedin.jersey.api.uri.UriComponent;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.RestConstants;
import com.linkedin.restli.internal.common.PathSegment;
import com.linkedin.restli.internal.common.URIMaskUtil;
import com.linkedin.restli.internal.common.URLEscaper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class QueryParamsDataMap {
    private static final Pattern SEGMENT_DELIMITER_PATTERN = Pattern.compile(Pattern.quote("."));

    private QueryParamsDataMap() {
    }

    public static String dataMapToQueryString(DataMap dataMap, URLEscaper.Escaping escaping) {
        if (dataMap == null || dataMap.isEmpty()) {
            return "";
        }
        Map<String, List<String>> queryStringParamsMap = QueryParamsDataMap.queryString(dataMap);
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(queryStringParamsMap.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            ArrayList values = new ArrayList(queryStringParamsMap.get(key));
            Collections.sort(values);
            for (String value : values) {
                sb.append(key).append('=').append(URLEscaper.escape(value, escaping)).append('&');
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Map<String, List<String>> queryString(DataMap dataMap) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        DataMap processedDataMap = QueryParamsDataMap.processProjections(dataMap, result);
        QueryParamsDataMap.iterate("", (DataComplex)processedDataMap, result);
        return result;
    }

    public static DataMap processProjections(DataMap dataMap, Map<String, List<String>> result) {
        for (String parameterName : RestConstants.PROJECTION_PARAMETERS) {
            if (!dataMap.containsKey((Object)parameterName)) continue;
            dataMap = QueryParamsDataMap.processIndividualProjection(dataMap, result, parameterName);
        }
        return dataMap;
    }

    private static DataMap processIndividualProjection(DataMap dataMap, Map<String, List<String>> result, String projectionKey) {
        DataMap dataMapClone;
        DataMap projectionsMap = dataMap.getDataMap(projectionKey);
        String encodedFields = URIMaskUtil.encodeMaskForURI(projectionsMap);
        result.put(projectionKey, Collections.singletonList(encodedFields));
        try {
            dataMapClone = dataMap.clone();
            dataMapClone.remove((Object)projectionKey);
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return dataMapClone;
    }

    private static void iterate(String keyPrefix, DataComplex dataComplex, Map<String, List<String>> result) {
        block5: {
            block4: {
                String separator;
                String string = separator = "".equals(keyPrefix) ? "" : ".";
                if (!(dataComplex instanceof DataMap)) break block4;
                DataMap dataMap = (DataMap)dataComplex;
                for (Map.Entry entry : dataMap.entrySet()) {
                    String escapedKeyPrefix = keyPrefix + separator + PathSegment.CODEC.encode((String)entry.getKey());
                    Object object = entry.getValue();
                    if (object instanceof DataComplex) {
                        QueryParamsDataMap.iterate(escapedKeyPrefix, (DataComplex)object, result);
                        continue;
                    }
                    String objStr = object instanceof ByteString ? Data.bytesToString((byte[])((ByteString)object).copyBytes()) : object.toString();
                    result.put(escapedKeyPrefix, Collections.singletonList(objStr));
                }
                break block5;
            }
            if (!(dataComplex instanceof DataList)) break block5;
            DataList dataList = (DataList)dataComplex;
            for (int i = 0; i < dataList.size(); ++i) {
                Object object = dataList.get(i);
                if (object instanceof DataComplex) {
                    QueryParamsDataMap.iterate(keyPrefix + "[" + i + "]", (DataComplex)object, result);
                    continue;
                }
                QueryParamsDataMap.addListValue(keyPrefix, i, object, result);
            }
        }
    }

    private static void addListValue(String keyPrefix, int listIndex, Object value, Map<String, List<String>> result) {
        assert (!(value instanceof DataComplex));
        if (keyPrefix.contains(".")) {
            result.put(keyPrefix + "[" + listIndex + "]", Collections.singletonList(value.toString()));
        } else if (result.containsKey(keyPrefix)) {
            result.get(keyPrefix).add(value.toString());
        } else {
            result.put(keyPrefix, new ArrayList<String>(Collections.singletonList(value.toString())));
        }
    }

    public static DataMap parseDataMapKeys(Map<String, List<String>> queryParameters) throws PathSegment.PathSegmentSyntaxException {
        PathSegment.MapMap dataMap = new PathSegment.MapMap();
        for (Map.Entry<String, List<String>> entry : queryParameters.entrySet()) {
            List<String> valueList = entry.getValue();
            if (valueList.size() == 1) {
                String[] key = SEGMENT_DELIMITER_PATTERN.split(entry.getKey());
                QueryParamsDataMap.parseParameter(key, valueList.get(0), dataMap);
                continue;
            }
            String parameterName = entry.getKey();
            if (parameterName.indexOf(46) != -1) {
                throw new PathSegment.PathSegmentSyntaxException("Multiple values of complex query parameter are not supported");
            }
            if (parameterName.charAt(parameterName.length() - 1) == ']') {
                throw new PathSegment.PathSegmentSyntaxException("Multiple values of indexed query parameter are not supported");
            }
            if (dataMap.containsKey(parameterName)) {
                throw new PathSegment.PathSegmentSyntaxException("Conflicting references to key " + parameterName + "[0]");
            }
            dataMap.put(parameterName, new DataList(valueList));
        }
        return (DataMap)QueryParamsDataMap.convertToDataCollection(dataMap);
    }

    private static void parseParameter(String[] key, String value, PathSegment.MapMap dataMap) throws PathSegment.PathSegmentSyntaxException {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Error parsing query parameters: query parameter name cannot be empty");
        }
        PathSegment.MapMap currentMap = dataMap;
        for (int index = 0; index < key.length - 1; ++index) {
            PathSegment pathSegment = PathSegment.parse(key[index]);
            currentMap = pathSegment.getNextLevelMap(currentMap);
        }
        PathSegment pathSegment = PathSegment.parse(key[key.length - 1]);
        pathSegment.putOnDataMap(currentMap, value);
    }

    private static DataComplex convertToDataCollection(Map<?, ?> map) {
        if (map instanceof PathSegment.MapMap) {
            DataMap result = new DataMap();
            PathSegment.MapMap mapMap = (PathSegment.MapMap)map;
            for (Map.Entry entry : mapMap.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Map) {
                    value = QueryParamsDataMap.convertToDataCollection((Map)value);
                }
                result.put(entry.getKey(), value);
            }
            return result;
        }
        if (map instanceof PathSegment.ListMap) {
            DataList result = new DataList();
            PathSegment.ListMap listMap = (PathSegment.ListMap)map;
            ArrayList sortedKeys = new ArrayList(listMap.keySet());
            Collections.sort(sortedKeys);
            for (Integer key : sortedKeys) {
                Object object = map.get(key);
                if (object instanceof Map) {
                    object = QueryParamsDataMap.convertToDataCollection((Map)object);
                }
                result.add(object);
            }
            return result;
        }
        throw new IllegalArgumentException("Only MapMap or ListMap input argument types are allowed");
    }

    public static void addSortedParams(UriBuilder uriBuilder, Map<String, List<String>> params) {
        ArrayList<String> keysList = new ArrayList<String>(params.keySet());
        Collections.sort(keysList);
        for (String key : keysList) {
            ArrayList values = new ArrayList(params.get(key));
            Collections.sort(values);
            for (String value : values) {
                uriBuilder.queryParam(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.QUERY_PARAM), new Object[]{UriComponent.encode((String)value, (UriComponent.Type)UriComponent.Type.QUERY_PARAM)});
            }
        }
    }

    public static void addSortedParams(UriBuilder uriBuilder, DataMap params) {
        QueryParamsDataMap.addSortedParams(uriBuilder, QueryParamsDataMap.queryString(params));
    }

    public static ComplexResourceKey<?, ?> fixUpComplexKeySingletonArray(ComplexResourceKey<?, ?> complexResourceKey) {
        Object key = complexResourceKey.getKey();
        DataMap dataMap = key.data();
        List fields = key.schema() == null ? Collections.emptyList() : key.schema().getFields();
        for (RecordDataSchema.Field f : fields) {
            Object arrayFieldValue;
            DataSchema.Type type = f.getType().getType();
            String fieldName = f.getName();
            if (type != DataSchema.Type.ARRAY || !dataMap.containsKey((Object)fieldName) || (arrayFieldValue = dataMap.get((Object)fieldName)) instanceof DataList) continue;
            DataList list = new DataList();
            list.add(arrayFieldValue);
            ValidateDataAgainstSchema.validate((Object)list, (DataSchema)f.getType(), (ValidationOptions)new ValidationOptions(RequiredMode.CAN_BE_ABSENT_IF_HAS_DEFAULT, CoercionMode.STRING_TO_PRIMITIVE));
            dataMap.put((Object)fieldName, (Object)list);
        }
        RecordTemplate wrappedKey = (RecordTemplate)DataTemplateUtil.wrap((Object)dataMap, key.getClass());
        ComplexResourceKey newKey = new ComplexResourceKey(wrappedKey, complexResourceKey.getParams());
        return newKey;
    }
}

