/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.verify;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.executors.ScalingThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCompletenessVerifier
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DataCompletenessVerifier.class);
    private static final String COMPACTION_COMPLETENESS_VERIFICATION_PREFIX = "compaction.completeness.verification.";
    private static final String COMPACTION_COMPLETENESS_VERIFICATION_CLASS = "compaction.completeness.verification.class";
    private static final String COMPACTION_COMPLETENESS_VERIFICATION_THREAD_POOL_SIZE = "compaction.completeness.verification.thread.pool.size";
    private static final int DEFAULT_COMPACTION_COMPLETENESS_VERIFICATION_THREAD_POOL_SIZE = 20;
    private final State props;
    private final int threadPoolSize;
    private final ListeningExecutorService exeSvc;
    private final Class<? extends AbstractRunner> runnerClass;

    public DataCompletenessVerifier(State props) {
        this.props = props;
        this.threadPoolSize = this.getDataCompletenessVerificationThreadPoolSize();
        this.exeSvc = this.getExecutorService();
        this.runnerClass = this.getRunnerClass();
    }

    private ListeningExecutorService getExecutorService() {
        return ExecutorsUtils.loggingDecorator((ExecutorService)ScalingThreadPoolExecutor.newScalingThreadPool((int)0, (int)this.threadPoolSize, (long)TimeUnit.SECONDS.toMillis(10L)));
    }

    private int getDataCompletenessVerificationThreadPoolSize() {
        return this.props.getPropAsInt(COMPACTION_COMPLETENESS_VERIFICATION_THREAD_POOL_SIZE, 20);
    }

    private Class<? extends AbstractRunner> getRunnerClass() {
        Preconditions.checkArgument((boolean)this.props.contains(COMPACTION_COMPLETENESS_VERIFICATION_CLASS), (Object)"Missing required property compaction.completeness.verification.class");
        try {
            return Class.forName(this.props.getProp(COMPACTION_COMPLETENESS_VERIFICATION_CLASS));
        }
        catch (Throwable t) {
            LOG.error("Failed to get data completeness verification class", t);
            throw Throwables.propagate((Throwable)t);
        }
    }

    public ListenableFuture<Results> verify(Iterable<Dataset> datasets) {
        return this.exeSvc.submit((Callable)this.getRunner(datasets));
    }

    private AbstractRunner getRunner(Iterable<Dataset> datasets) {
        try {
            return this.runnerClass.getDeclaredConstructor(Iterable.class, State.class).newInstance(datasets, this.props);
        }
        catch (Throwable t) {
            LOG.error("Failed to instantiate data completeness verification class", t);
            throw Throwables.propagate((Throwable)t);
        }
    }

    @Override
    public void close() throws IOException {
        ExecutorsUtils.shutdownExecutorService((ExecutorService)this.exeSvc, (Optional)Optional.of((Object)LOG));
    }

    public void closeNow() {
        ExecutorsUtils.shutdownExecutorService((ExecutorService)this.exeSvc, (Optional)Optional.of((Object)LOG), (long)0L, (TimeUnit)TimeUnit.NANOSECONDS);
    }

    public static abstract class AbstractRunner
    implements Callable<Results> {
        protected final Iterable<Dataset> datasets;
        protected final State props;

        public AbstractRunner(Iterable<Dataset> datasets, State props) {
            this.datasets = datasets;
            this.props = props;
        }
    }

    public static class Results
    implements Iterable<Result> {
        private final Iterable<Result> results;

        public Results(Iterable<Result> results) {
            this.results = results;
        }

        @Override
        public Iterator<Result> iterator() {
            return this.results.iterator();
        }

        public static class Result {
            private final Dataset dataset;
            private final Status status;
            private final Map<String, Object> verificationContext;

            public Result(Dataset dataset, Status status) {
                this.dataset = dataset;
                this.status = status;
                this.verificationContext = ImmutableMap.of();
            }

            public Result(Dataset dataset, Status status, Map<String, Object> verificationContext) {
                this.dataset = dataset;
                this.status = status;
                this.verificationContext = verificationContext;
            }

            public Dataset dataset() {
                return this.dataset;
            }

            public Status status() {
                return this.status;
            }

            public Map<String, Object> verificationContext() {
                return this.verificationContext;
            }

            public static enum Status {
                PASSED,
                FAILED;

            }
        }
    }
}

