/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.nodes;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;

public class GroupMember
implements Closeable {
    private final PersistentEphemeralNode pen;
    private final PathChildrenCache cache;
    private final String thisId;

    public GroupMember(CuratorFramework client, String membershipPath, String thisId) {
        this(client, membershipPath, thisId, CuratorFrameworkFactory.getLocalAddress());
    }

    public GroupMember(CuratorFramework client, String membershipPath, String thisId, byte[] payload) {
        this.thisId = (String)Preconditions.checkNotNull((Object)thisId, (Object)"thisId cannot be null");
        this.cache = this.newPathChildrenCache(client, membershipPath);
        this.pen = this.newPersistentEphemeralNode(client, membershipPath, thisId, payload);
    }

    public void start() {
        this.pen.start();
        try {
            this.cache.start();
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            Throwables.propagate((Throwable)e);
        }
    }

    public void setThisData(byte[] data) {
        try {
            this.pen.setData(data);
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() {
        CloseableUtils.closeQuietly((Closeable)this.cache);
        CloseableUtils.closeQuietly((Closeable)this.pen);
    }

    public Map<String, byte[]> getCurrentMembers() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        boolean thisIdAdded = false;
        for (ChildData data : this.cache.getCurrentData()) {
            String id = this.idFromPath(data.getPath());
            thisIdAdded = thisIdAdded || id.equals(this.thisId);
            builder.put((Object)id, (Object)data.getData());
        }
        if (!thisIdAdded) {
            builder.put((Object)this.thisId, (Object)this.pen.getData());
        }
        return builder.build();
    }

    public String idFromPath(String path) {
        return ZKPaths.getNodeFromPath((String)path);
    }

    protected PersistentEphemeralNode newPersistentEphemeralNode(CuratorFramework client, String membershipPath, String thisId, byte[] payload) {
        return new PersistentEphemeralNode(client, PersistentEphemeralNode.Mode.EPHEMERAL, ZKPaths.makePath((String)membershipPath, (String)thisId), payload);
    }

    protected PathChildrenCache newPathChildrenCache(CuratorFramework client, String membershipPath) {
        return new PathChildrenCache(client, membershipPath, true);
    }
}

