/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.example.simplejson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.converter.ToAvroConverterBase;

public class SimpleJsonConverter
extends ToAvroConverterBase<String, String> {
    private static final Gson GSON = new Gson();
    private static final Type FIELD_ENTRY_TYPE = new TypeToken<Map<String, Object>>(){}.getType();

    public Schema convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return new Schema.Parser().parse(inputSchema);
    }

    public Iterable<GenericRecord> convertRecord(Schema schema, String inputRecord, WorkUnitState workUnit) throws DataConversionException {
        JsonElement element = (JsonElement)GSON.fromJson(inputRecord, JsonElement.class);
        Map fields = (Map)GSON.fromJson(element, FIELD_ENTRY_TYPE);
        GenericData.Record record = new GenericData.Record(schema);
        for (Map.Entry entry : fields.entrySet()) {
            record.put((String)entry.getKey(), entry.getValue());
        }
        return new SingleRecordIterable((Object)record);
    }
}

