/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.example.simplejson;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.example.simplejson.SimpleJsonExtractor;
import org.apache.gobblin.source.Source;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.workunit.Extract;
import org.apache.gobblin.source.workunit.WorkUnit;

public class SimpleJsonSource
implements Source<String, String> {
    public static final String SOURCE_FILE_KEY = "source.file";

    public List<WorkUnit> getWorkunits(SourceState state) {
        ArrayList workUnits = Lists.newArrayList();
        if (!state.contains("source.filebased.files.to.pull")) {
            return workUnits;
        }
        Extract extract = new Extract(Extract.TableType.SNAPSHOT_ONLY, state.getProp("extract.namespace", "ExampleNamespace"), "ExampleTable");
        String filesToPull = state.getProp("source.filebased.files.to.pull");
        for (String file : Splitter.on((char)',').omitEmptyStrings().split((CharSequence)filesToPull)) {
            WorkUnit workUnit = WorkUnit.create((Extract)extract);
            workUnit.setProp(SOURCE_FILE_KEY, (Object)file);
            workUnits.add(workUnit);
        }
        return workUnits;
    }

    public Extractor<String, String> getExtractor(WorkUnitState state) throws IOException {
        return new SimpleJsonExtractor(state);
    }

    public void shutdown(SourceState state) {
    }
}

