/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.D2Client;
import com.linkedin.d2.balancer.D2ClientConfig;
import com.linkedin.d2.balancer.Facilities;
import com.linkedin.d2.balancer.LoadBalancerWithFacilities;
import com.linkedin.d2.balancer.LoadBalancerWithFacilitiesFactory;
import com.linkedin.d2.balancer.ZKFSLoadBalancerWithFacilitiesFactory;
import com.linkedin.d2.balancer.clients.DynamicClient;
import com.linkedin.d2.balancer.clients.RetryClient;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckOperations;
import com.linkedin.d2.balancer.zkfs.ZKFSTogglingLoadBalancerFactoryImpl;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.http.client.HttpClientFactory;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class D2ClientBuilder {
    private boolean _restOverStream = false;
    private final D2ClientConfig _config = new D2ClientConfig();

    public D2Client build() {
        Map<String, TransportClientFactory> transportClientFactories = this._config.clientFactories == null ? this.createDefaultTransportClientFactories() : this._config.clientFactories;
        LoadBalancerWithFacilitiesFactory loadBalancerFactory = this._config.lbWithFacilitiesFactory == null ? new ZKFSLoadBalancerWithFacilitiesFactory() : this._config.lbWithFacilitiesFactory;
        D2ClientConfig cfg = new D2ClientConfig(this._config.zkHosts, this._config.zkSessionTimeoutInMs, this._config.zkStartupTimeoutInMs, this._config.lbWaitTimeout, this._config.lbWaitUnit, this._config.flagFile, this._config.basePath, this._config.fsBasePath, this._config.componentFactory, transportClientFactories, this._config.lbWithFacilitiesFactory, this._config.sslContext, this._config.sslParameters, this._config.isSSLEnabled, this._config.shutdownAsynchronously, this._config.isSymlinkAware, this._config.clientServicesConfig, this._config.d2ServicePath, this._config.useNewEphemeralStoreWatcher, this._config._healthCheckOperations, this._config._executorService, this._config.retry, this._config.retryLimit);
        LoadBalancerWithFacilities loadBalancer = loadBalancerFactory.create(cfg);
        D2Client d2Client = new DynamicClient(loadBalancer, loadBalancer, this._restOverStream);
        if (this._config.retry) {
            d2Client = new RetryClient(d2Client, this._config.retryLimit);
        }
        if (this._config.clientFactories != transportClientFactories) {
            d2Client = new TransportClientFactoryAwareD2Client(d2Client, transportClientFactories.values());
        }
        return d2Client;
    }

    public D2ClientBuilder setZkHosts(String zkHosts) {
        this._config.zkHosts = zkHosts;
        return this;
    }

    public D2ClientBuilder setZkSessionTimeout(long zkSessionTimeout, TimeUnit unit) {
        this._config.zkSessionTimeoutInMs = unit.toMillis(zkSessionTimeout);
        return this;
    }

    public D2ClientBuilder setZkStartupTimeout(long zkStartupTimeout, TimeUnit unit) {
        this._config.zkStartupTimeoutInMs = unit.toMillis(zkStartupTimeout);
        return this;
    }

    public D2ClientBuilder setLbWaitTimeout(long lbWaitTimeout, TimeUnit unit) {
        this._config.lbWaitTimeout = lbWaitTimeout;
        this._config.lbWaitUnit = unit;
        return this;
    }

    public D2ClientBuilder setFlagFile(String flagFile) {
        this._config.flagFile = flagFile;
        return this;
    }

    public D2ClientBuilder setBasePath(String basePath) {
        this._config.basePath = basePath;
        return this;
    }

    public D2ClientBuilder setFsBasePath(String fsBasePath) {
        this._config.fsBasePath = fsBasePath;
        return this;
    }

    public D2ClientBuilder setComponentFactory(ZKFSTogglingLoadBalancerFactoryImpl.ComponentFactory componentFactory) {
        this._config.componentFactory = componentFactory;
        return this;
    }

    public D2ClientBuilder setSSLContext(SSLContext sslContext) {
        this._config.sslContext = sslContext;
        return this;
    }

    public D2ClientBuilder setSSLParameters(SSLParameters sslParameters) {
        this._config.sslParameters = sslParameters;
        return this;
    }

    public D2ClientBuilder setIsSSLEnabled(boolean isSSLEnabled) {
        this._config.isSSLEnabled = isSSLEnabled;
        return this;
    }

    public D2ClientBuilder setShutdownAsynchronously(boolean shutdownAsynchronously) {
        this._config.shutdownAsynchronously = shutdownAsynchronously;
        return this;
    }

    public D2ClientBuilder setIsSymlinkAware(boolean isSymlinkAware) {
        this._config.isSymlinkAware = isSymlinkAware;
        return this;
    }

    public D2ClientBuilder setClientServicesConfig(Map<String, Map<String, Object>> clientServicesConfig) {
        this._config.clientServicesConfig = clientServicesConfig;
        return this;
    }

    public D2ClientBuilder setD2ServicePath(String d2ServicePath) {
        this._config.d2ServicePath = d2ServicePath;
        return this;
    }

    public D2ClientBuilder setHealthCheckOperations(HealthCheckOperations healthCheckOperations) {
        this._config._healthCheckOperations = healthCheckOperations;
        return this;
    }

    public D2ClientBuilder setExecutorService(ScheduledExecutorService executorService) {
        this._config._executorService = executorService;
        return this;
    }

    public D2ClientBuilder setRetry(boolean retry) {
        this._config.retry = retry;
        return this;
    }

    public D2ClientBuilder setRetryLimit(int retryLimit) {
        this._config.retryLimit = retryLimit;
        return this;
    }

    public D2ClientBuilder setClientFactories(Map<String, TransportClientFactory> clientFactories) {
        this._config.clientFactories = clientFactories;
        return this;
    }

    public D2ClientBuilder setLoadBalancerWithFacilitiesFactory(LoadBalancerWithFacilitiesFactory lbWithFacilitiesFactory) {
        this._config.lbWithFacilitiesFactory = lbWithFacilitiesFactory;
        return this;
    }

    public D2ClientBuilder setRestOverStream(boolean restOverStream) {
        this._restOverStream = restOverStream;
        return this;
    }

    public D2ClientBuilder setUseNewEphemeralStoreWatcher(boolean useNewEphemeralStoreWatcher) {
        this._config.useNewEphemeralStoreWatcher = useNewEphemeralStoreWatcher;
        return this;
    }

    private Map<String, TransportClientFactory> createDefaultTransportClientFactories() {
        HashMap<String, TransportClientFactory> clientFactories = new HashMap<String, TransportClientFactory>();
        clientFactories.put("http", (TransportClientFactory)new HttpClientFactory());
        return clientFactories;
    }

    private class TransportClientFactoryAwareD2Client
    implements D2Client {
        private D2Client _d2Client;
        private Collection<TransportClientFactory> _clientFactories;

        TransportClientFactoryAwareD2Client(D2Client d2Client, Collection<TransportClientFactory> clientFactories) {
            this._d2Client = d2Client;
            this._clientFactories = clientFactories;
        }

        @Override
        public Facilities getFacilities() {
            return this._d2Client.getFacilities();
        }

        public void start(Callback<None> callback) {
            this._d2Client.start(callback);
        }

        public Future<RestResponse> restRequest(RestRequest request) {
            return this._d2Client.restRequest(request);
        }

        public Future<RestResponse> restRequest(RestRequest request, RequestContext requestContext) {
            return this._d2Client.restRequest(request, requestContext);
        }

        public void restRequest(RestRequest request, Callback<RestResponse> callback) {
            this._d2Client.restRequest(request, callback);
        }

        public void restRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
            this._d2Client.restRequest(request, requestContext, callback);
        }

        public void streamRequest(StreamRequest request, Callback<StreamResponse> callback) {
            this._d2Client.streamRequest(request, callback);
        }

        public void streamRequest(StreamRequest request, RequestContext requestContext, Callback<StreamResponse> callback) {
            this._d2Client.streamRequest(request, requestContext, callback);
        }

        public void shutdown(Callback<None> callback) {
            this._d2Client.shutdown(callback);
            for (TransportClientFactory clientFactory : this._clientFactories) {
                clientFactory.shutdown((Callback)new FutureCallback());
            }
        }

        public Map<String, Object> getMetadata(URI uri) {
            return this._d2Client.getMetadata(uri);
        }
    }
}

