/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.config;

import com.linkedin.d2.ConsistentHashAlgorithmEnum;
import com.linkedin.d2.D2LoadBalancerStrategyProperties;
import com.linkedin.d2.balancer.properties.util.PropertyUtil;
import com.linkedin.d2.hashConfigType;
import com.linkedin.d2.hashMethodEnum;
import com.linkedin.d2.quarantineInfo;
import com.linkedin.data.template.StringArray;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LoadBalancerStrategyPropertiesConverter {
    public static Map<String, Object> toProperties(D2LoadBalancerStrategyProperties config) {
        if (config == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (config.hasGlobalStepDown()) {
            map.put("http.loadBalancer.globalStepDown", config.getGlobalStepDown().toString());
        }
        if (config.hasGlobalStepUp()) {
            map.put("http.loadBalancer.globalStepUp", config.getGlobalStepUp().toString());
        }
        if (config.hasInitialRecoveryLevel()) {
            map.put("http.loadBalancer.initialRecoveryLevel", config.getInitialRecoveryLevel().toString());
        }
        if (config.hasRingRampFactor()) {
            map.put("http.loadBalancer.ringRampFactor", config.getRingRampFactor().toString());
        }
        if (config.hasHighWaterMark()) {
            map.put("http.loadBalancer.highWaterMark", config.getHighWaterMark().toString());
        }
        if (config.hasLowWaterMark()) {
            map.put("http.loadBalancer.lowWaterMark", config.getLowWaterMark().toString());
        }
        if (config.hasPointsPerWeight()) {
            map.put("http.loadBalancer.pointsPerWeight", config.getPointsPerWeight().toString());
        }
        if (config.hasUpdateIntervalMs()) {
            map.put("http.loadBalancer.updateIntervalMs", config.getUpdateIntervalMs().toString());
        }
        if (config.hasMinCallCountHighWaterMark()) {
            map.put("http.loadBalancer.clusterMinCallCount.highWaterMark", config.getMinCallCountHighWaterMark().toString());
        }
        if (config.hasHashRingPointCleanupRate()) {
            map.put("http.loadBalancer.hashRingPointCleanupRate", config.getHashRingPointCleanupRate().toString());
        }
        if (config.hasMinCallCountLowWaterMark()) {
            map.put("http.loadBalancer.clusterMinCallCount.lowWaterMark", config.getMinCallCountLowWaterMark().toString());
        }
        if (config.hasHashMethod()) {
            switch (config.getHashMethod()) {
                case RANDOM: {
                    map.put("http.loadBalancer.hashMethod", "none");
                    break;
                }
                case URI_REGEX: {
                    map.put("http.loadBalancer.hashMethod", "uriRegex");
                    break;
                }
                default: {
                    map.put("http.loadBalancer.hashMethod", "none");
                }
            }
        }
        if (config.hasHashConfig()) {
            hashConfigType hashConfig = config.getHashConfig();
            HashMap<String, Object> hashConfigProperties = new HashMap<String, Object>();
            if (hashConfig.hasUriRegexes()) {
                hashConfigProperties.put("regexes", hashConfig.getUriRegexes().stream().collect(Collectors.toList()));
            }
            if (hashConfig.hasFailOnNoMatch()) {
                hashConfigProperties.put("failOnNoMatch", hashConfig.isFailOnNoMatch().toString());
            }
            if (hashConfig.hasWarnOnNoMatch()) {
                hashConfigProperties.put("warnOnNoMatch", hashConfig.isWarnOnNoMatch().toString());
            }
            map.put("http.loadBalancer.hashConfig", hashConfigProperties);
        }
        if (config.hasUpdateOnlyAtInterval()) {
            map.put("http.loadBalancer.updateOnlyAtInterval", config.isUpdateOnlyAtInterval().toString());
        }
        if (config.hasConsistentHashAlgorithm()) {
            switch (config.getConsistentHashAlgorithm()) {
                case MULTI_PROBE: {
                    map.put("http.loadBalancer.consistentHashAlgorithm", "multiProbe");
                    break;
                }
                case POINT_BASED: {
                    map.put("http.loadBalancer.consistentHashAlgorithm", "pointBased");
                }
            }
        }
        if (config.hasNumberOfProbes()) {
            map.put("http.loadBalancer.consistentHashNumProbes", config.getNumberOfProbes().toString());
        }
        if (config.hasQuarantineCfg()) {
            quarantineInfo quarantineInfo2 = config.getQuarantineCfg();
            if (quarantineInfo2.hasQuarantineMaxPercent()) {
                map.put("http.loadBalancer.quarantine.maxPercent", quarantineInfo2.getQuarantineMaxPercent().toString());
            }
            if (quarantineInfo2.hasQuarantineMethod()) {
                map.put("http.loadBalancer.quarantine.method", quarantineInfo2.getQuarantineMethod().toString());
            }
            if (quarantineInfo2.hasQuarantineLatency()) {
                map.put("http.loadBalancer.quarantine.latency", quarantineInfo2.getQuarantineLatency().toString());
            }
        }
        if (config.hasErrorStatusRegex()) {
            map.put("http.loadBalancer.errorStatusRegex", config.getErrorStatusRegex());
        }
        return map;
    }

    public static D2LoadBalancerStrategyProperties toConfig(Map<String, Object> properties) {
        D2LoadBalancerStrategyProperties config = new D2LoadBalancerStrategyProperties();
        if (properties.containsKey("http.loadBalancer.globalStepDown")) {
            config.setGlobalStepDown(PropertyUtil.coerce(properties.get("http.loadBalancer.globalStepDown"), Double.class));
        }
        if (properties.containsKey("http.loadBalancer.globalStepUp")) {
            config.setGlobalStepUp(PropertyUtil.coerce(properties.get("http.loadBalancer.globalStepUp"), Double.class));
        }
        if (properties.containsKey("http.loadBalancer.initialRecoveryLevel")) {
            config.setInitialRecoveryLevel(PropertyUtil.coerce(properties.get("http.loadBalancer.initialRecoveryLevel"), Double.class));
        }
        if (properties.containsKey("http.loadBalancer.ringRampFactor")) {
            config.setRingRampFactor(PropertyUtil.coerce(properties.get("http.loadBalancer.ringRampFactor"), Double.class));
        }
        if (properties.containsKey("http.loadBalancer.highWaterMark")) {
            config.setHighWaterMark(PropertyUtil.coerce(properties.get("http.loadBalancer.highWaterMark"), Double.class));
        }
        if (properties.containsKey("http.loadBalancer.lowWaterMark")) {
            config.setLowWaterMark(PropertyUtil.coerce(properties.get("http.loadBalancer.lowWaterMark"), Double.class));
        }
        if (properties.containsKey("http.loadBalancer.pointsPerWeight")) {
            config.setPointsPerWeight(PropertyUtil.coerce(properties.get("http.loadBalancer.pointsPerWeight"), Integer.class));
        }
        if (properties.containsKey("http.loadBalancer.updateIntervalMs")) {
            config.setUpdateIntervalMs(PropertyUtil.coerce(properties.get("http.loadBalancer.updateIntervalMs"), Long.class));
        }
        if (properties.containsKey("http.loadBalancer.clusterMinCallCount.highWaterMark")) {
            config.setMinCallCountHighWaterMark(PropertyUtil.coerce(properties.get("http.loadBalancer.clusterMinCallCount.highWaterMark"), Long.class));
        }
        if (properties.containsKey("http.loadBalancer.clusterMinCallCount.lowWaterMark")) {
            config.setMinCallCountLowWaterMark(PropertyUtil.coerce(properties.get("http.loadBalancer.clusterMinCallCount.lowWaterMark"), Long.class));
        }
        if (properties.containsKey("http.loadBalancer.hashRingPointCleanupRate")) {
            config.setHashRingPointCleanupRate(PropertyUtil.coerce(properties.get("http.loadBalancer.hashRingPointCleanupRate"), Double.class));
        }
        if (properties.containsKey("http.loadBalancer.hashMethod")) {
            String hashMethodString = PropertyUtil.coerce(properties.get("http.loadBalancer.hashMethod"), String.class);
            if ("none".equalsIgnoreCase(hashMethodString)) {
                config.setHashMethod(hashMethodEnum.RANDOM);
            } else if ("uriRegex".equalsIgnoreCase(hashMethodString)) {
                config.setHashMethod(hashMethodEnum.URI_REGEX);
            }
        }
        if (properties.containsKey("http.loadBalancer.hashConfig")) {
            hashConfigType hashConfig = new hashConfigType();
            Map hashConfigProperties = (Map)properties.get("http.loadBalancer.hashConfig");
            if (hashConfigProperties.containsKey("regexes")) {
                List uriRegexes = (List)hashConfigProperties.get("regexes");
                hashConfig.setUriRegexes(new StringArray((Collection)uriRegexes));
            }
            if (hashConfigProperties.containsKey("warnOnNoMatch")) {
                String warnOnNoMatchString = (String)hashConfigProperties.get("warnOnNoMatch");
                hashConfig.setWarnOnNoMatch(Boolean.parseBoolean(warnOnNoMatchString));
            }
            if (hashConfigProperties.containsKey("failOnNoMatch")) {
                String failOnNoMatchString = (String)hashConfigProperties.get("failOnNoMatch");
                hashConfig.setFailOnNoMatch(Boolean.parseBoolean(failOnNoMatchString));
            }
            config.setHashConfig(hashConfig);
        }
        if (properties.containsKey("http.loadBalancer.updateOnlyAtInterval")) {
            config.setUpdateOnlyAtInterval(PropertyUtil.coerce(properties.get("http.loadBalancer.updateOnlyAtInterval"), Boolean.class));
        }
        if (properties.containsKey("http.loadBalancer.consistentHashAlgorithm")) {
            String consistentHashAlgorithm = PropertyUtil.coerce(properties.get("http.loadBalancer.consistentHashAlgorithm"), String.class);
            if ("pointBased".equalsIgnoreCase(consistentHashAlgorithm)) {
                config.setConsistentHashAlgorithm(ConsistentHashAlgorithmEnum.POINT_BASED);
            } else if ("multiProbe".equalsIgnoreCase(consistentHashAlgorithm)) {
                config.setConsistentHashAlgorithm(ConsistentHashAlgorithmEnum.MULTI_PROBE);
            }
        }
        if (properties.containsKey("http.loadBalancer.consistentHashNumProbes")) {
            config.setNumberOfProbes(PropertyUtil.coerce(properties.get("http.loadBalancer.consistentHashNumProbes"), Integer.class));
        }
        if (properties.containsKey("http.loadBalancer.quarantine.maxPercent") || properties.containsKey("http.loadBalancer.quarantine.method") || properties.containsKey("http.loadBalancer.quarantine.latency")) {
            quarantineInfo quarantineInfo2 = new quarantineInfo();
            if (properties.containsKey("http.loadBalancer.quarantine.maxPercent")) {
                quarantineInfo2.setQuarantineMaxPercent(PropertyUtil.coerce(properties.get("http.loadBalancer.quarantine.maxPercent"), Double.class));
            }
            if (properties.containsKey("http.loadBalancer.quarantine.method")) {
                quarantineInfo2.setQuarantineMethod(PropertyUtil.coerce(properties.get("http.loadBalancer.quarantine.method"), String.class));
            }
            if (properties.containsKey("http.loadBalancer.quarantine.latency")) {
                quarantineInfo2.setQuarantineLatency(PropertyUtil.coerce(properties.get("http.loadBalancer.quarantine.latency"), Long.class));
            }
            config.setQuarantineCfg(quarantineInfo2);
        }
        if (properties.containsKey("http.loadBalancer.errorStatusRegex")) {
            config.setErrorStatusRegex(PropertyUtil.coerce(properties.get("http.loadBalancer.errorStatusRegex"), String.class));
        }
        return config;
    }
}

