/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.servers;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.servers.ZooKeeperServer;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperEphemeralStore;
import com.linkedin.util.ArgumentUtil;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperAnnouncer {
    private final ZooKeeperServer _server;
    private static final Logger _log = LoggerFactory.getLogger(ZooKeeperAnnouncer.class);
    private String _cluster;
    private URI _uri;
    private Map<Integer, PartitionData> _partitionDataMap;
    private Map<String, Object> _uriSpecificProperties;
    private boolean _isUp;
    private final Deque<Callback<None>> _pendingMarkDown;
    private final Deque<Callback<None>> _pendingMarkUp;

    public ZooKeeperAnnouncer(ZooKeeperServer server) {
        this(server, true);
    }

    public ZooKeeperAnnouncer(ZooKeeperServer server, boolean initialIsUp) {
        this._server = server;
        this._isUp = initialIsUp;
        this._pendingMarkDown = new ArrayDeque<Callback<None>>();
        this._pendingMarkUp = new ArrayDeque<Callback<None>>();
    }

    public synchronized void start(Callback<None> callback) {
        if (this._isUp) {
            this.markUp(callback);
        } else {
            callback.onSuccess((Object)None.none());
        }
    }

    synchronized void retry(Callback<None> callback) {
        if (!this._pendingMarkDown.isEmpty() || !this._pendingMarkUp.isEmpty()) {
            if (this._isUp) {
                this.markUp(callback);
            } else {
                this.markDown(callback);
            }
        }
    }

    public void setStore(ZooKeeperEphemeralStore<UriProperties> store) {
        this._server.setStore(store);
    }

    public void reset(final Callback<None> callback) {
        this.markDown(new Callback<None>(){

            public void onSuccess(None none) {
                ZooKeeperAnnouncer.this.markUp((Callback<None>)callback);
            }

            public void onError(Throwable e) {
                callback.onError(e);
            }
        });
    }

    public synchronized void markUp(final Callback<None> callback) {
        this._isUp = true;
        this._server.markUp(this._cluster, this._uri, this._partitionDataMap, this._uriSpecificProperties, new Callback<None>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable e) {
                if (e instanceof KeeperException.ConnectionLossException) {
                    ZooKeeperAnnouncer zooKeeperAnnouncer = ZooKeeperAnnouncer.this;
                    synchronized (zooKeeperAnnouncer) {
                        ZooKeeperAnnouncer.this._pendingMarkUp.add(callback);
                    }
                    _log.warn("failed to mark up uri {} due to ConnectionLossException.", (Object)ZooKeeperAnnouncer.this._uri);
                } else {
                    callback.onError(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(None result) {
                _log.info("markUp for uri = {} succeeded.", (Object)ZooKeeperAnnouncer.this._uri);
                callback.onSuccess((Object)result);
                ZooKeeperAnnouncer zooKeeperAnnouncer = ZooKeeperAnnouncer.this;
                synchronized (zooKeeperAnnouncer) {
                    ZooKeeperAnnouncer.this.drain(ZooKeeperAnnouncer.this._pendingMarkDown, new CancellationException("Cancelled because a more recent markUp request succeeded."));
                    ZooKeeperAnnouncer.this.drain(ZooKeeperAnnouncer.this._pendingMarkUp, null);
                }
            }
        });
        _log.info("overrideMarkUp is called for uri = " + this._uri);
    }

    public synchronized void markDown(final Callback<None> callback) {
        this._isUp = false;
        this._server.markDown(this._cluster, this._uri, new Callback<None>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable e) {
                if (e instanceof KeeperException.ConnectionLossException) {
                    ZooKeeperAnnouncer zooKeeperAnnouncer = ZooKeeperAnnouncer.this;
                    synchronized (zooKeeperAnnouncer) {
                        ZooKeeperAnnouncer.this._pendingMarkDown.add(callback);
                    }
                    _log.warn("failed to mark down uri {} due to ConnectionLossException.", (Object)ZooKeeperAnnouncer.this._uri);
                } else {
                    callback.onError(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(None result) {
                _log.info("markDown for uri = {} succeeded.", (Object)ZooKeeperAnnouncer.this._uri);
                callback.onSuccess((Object)result);
                ZooKeeperAnnouncer zooKeeperAnnouncer = ZooKeeperAnnouncer.this;
                synchronized (zooKeeperAnnouncer) {
                    ZooKeeperAnnouncer.this.drain(ZooKeeperAnnouncer.this._pendingMarkUp, new CancellationException("Cancelled because a more recent markDown request succeeded."));
                    ZooKeeperAnnouncer.this.drain(ZooKeeperAnnouncer.this._pendingMarkDown, null);
                }
            }
        });
        _log.info("overrideMarkDown is called for uri = " + this._uri);
    }

    private void drain(Deque<Callback<None>> callbacks, Throwable t) {
        while (!callbacks.isEmpty()) {
            try {
                if (t != null) {
                    callbacks.poll().onError(t);
                    continue;
                }
                callbacks.poll().onSuccess((Object)None.none());
            }
            catch (Throwable throwable) {
                _log.error("Unexpected throwable from markUp/markDown callback.", throwable);
            }
        }
    }

    public String getCluster() {
        return this._cluster;
    }

    public void setCluster(String cluster) {
        this._cluster = cluster;
    }

    public String getUri() {
        return this._uri.toString();
    }

    public void setUri(String uri) {
        this._uri = URI.create(uri);
    }

    public void setUriSpecificProperties(Map<String, Object> uriSpecificProperties) {
        this._uriSpecificProperties = Collections.unmodifiableMap(uriSpecificProperties);
    }

    public Map<String, Object> getUriSpecificProperties() {
        return this._uriSpecificProperties == null ? Collections.emptyMap() : this._uriSpecificProperties;
    }

    public void setWeightOrPartitionData(Object data) {
        ArgumentUtil.notNull((Object)data, (String)"weightOrPartitionData");
        if (data instanceof Number) {
            this.setWeight(((Number)data).doubleValue());
        } else {
            try {
                Map partitionDataMap = (Map)data;
                this.setPartitionData(partitionDataMap);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("data: " + data + " is not an instance of Map", e);
            }
        }
    }

    public void setWeight(double weight) {
        HashMap<Integer, PartitionData> partitionDataMap = new HashMap<Integer, PartitionData>(1);
        partitionDataMap.put(0, new PartitionData(weight));
        this._partitionDataMap = Collections.unmodifiableMap(partitionDataMap);
    }

    public void setPartitionData(Map<Integer, PartitionData> partitionData) {
        this._partitionDataMap = Collections.unmodifiableMap(new HashMap<Integer, PartitionData>(partitionData));
    }

    public Map<Integer, PartitionData> getPartitionData() {
        return this._partitionDataMap;
    }
}

