/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.common.util.MapUtil;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckOperations;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegraderLoadBalancerStrategyConfig {
    private final long _updateIntervalMs;
    private final boolean _updateOnlyAtInterval;
    private final int _pointsPerWeight;
    private final String _hashMethod;
    private final Map<String, Object> _hashConfig;
    private final Clock _clock;
    private static final Logger _log = LoggerFactory.getLogger(DegraderLoadBalancerStrategyConfig.class);
    private final double _initialRecoveryLevel;
    private final double _ringRampFactor;
    private final double _highWaterMark;
    private final double _lowWaterMark;
    private final double _globalStepUp;
    private final double _globalStepDown;
    private final long _minClusterCallCountHighWaterMark;
    private final long _minClusterCallCountLowWaterMark;
    private final double _hashRingPointCleanUpRate;
    private final String _consistentHashAlgorithm;
    private final int _numProbes;
    private final String _servicePath;
    private final double _quarantineMaxPercent;
    private final ScheduledExecutorService _executorService;
    private final HealthCheckOperations _healthCheckOperations;
    private final String _healthCheckMethod;
    private final String _healthCheckPath;
    private final long _quarantineLatency;
    public static final Clock DEFAULT_CLOCK = SystemClock.instance();
    public static final double DEFAULT_INITIAL_RECOVERY_LEVEL = 0.01;
    public static final double DEFAULT_RAMP_FACTOR = 1.0;
    public static final long DEFAULT_UPDATE_INTERVAL_MS = 5000L;
    public static final boolean DEFAULT_UPDATE_ONLY_AT_INTERVAL = false;
    public static final int DEFAULT_POINTS_PER_WEIGHT = 100;
    public static final double DEFAULT_HIGH_WATER_MARK = 3000.0;
    public static final double DEFAULT_LOW_WATER_MARK = 500.0;
    public static final double DEFAULT_GLOBAL_STEP_UP = 0.2;
    public static final double DEFAULT_GLOBAL_STEP_DOWN = 0.2;
    public static final long DEFAULT_CLUSTER_MIN_CALL_COUNT_HIGH_WATER_MARK = 10L;
    public static final long DEFAULT_CLUSTER_MIN_CALL_COUNT_LOW_WATER_MARK = 5L;
    public static final double DEFAULT_HASHRING_POINT_CLEANUP_RATE = 0.2;
    public static final int DEFAULT_NUM_PROBES = 21;
    public static final double DEFAULT_QUARANTINE_MAXPERCENT = 0.0;
    public static final long DEFAULT_QUARANTINE_REENTRY_TIME = 30000L;
    public static final int DEFAULT_QUARANTINE_CHECKNUM = 5;
    public static final long DEFAULT_QUARANTINE_CHECK_INTERVAL = 1000L;
    public static final long DEFAULT_QUARANTINE_LATENCY = 100L;
    public static final String DEFAULT_QUARANTINE_METHOD = "OPTIONS";
    private static final double QUARANTINE_MAXPERCENT_CAP = 0.5;

    public DegraderLoadBalancerStrategyConfig(long updateIntervalMs) {
        this(updateIntervalMs, false, 100, null, Collections.emptyMap(), DEFAULT_CLOCK, 0.01, 1.0, 3000.0, 500.0, 0.2, 0.2, 10L, 5L, 0.2, null, 21, null, 0.0, null, null, DEFAULT_QUARANTINE_METHOD, null, 100L);
    }

    public DegraderLoadBalancerStrategyConfig(DegraderLoadBalancerStrategyConfig config) {
        this(config.getUpdateIntervalMs(), config.isUpdateOnlyAtInterval(), config.getPointsPerWeight(), config.getHashMethod(), config.getHashConfig(), config.getClock(), config.getInitialRecoveryLevel(), config.getRingRampFactor(), config.getHighWaterMark(), config.getLowWaterMark(), config.getGlobalStepUp(), config.getGlobalStepDown(), config.getMinClusterCallCountHighWaterMark(), config.getMinClusterCallCountLowWaterMark(), config.getHashRingPointCleanUpRate(), config.getConsistentHashAlgorithm(), config.getNumProbes(), config.getServicePath(), config.getQuarantineMaxPercent(), config.getExecutorService(), config.getHealthCheckOperations(), config.getHealthCheckMethod(), config.getHealthCheckPath(), config.getQuarantineLatency());
    }

    public DegraderLoadBalancerStrategyConfig(long updateIntervalMs, boolean updateOnlyAtInterval, int pointsPerWeight, String hashMethod, Map<String, Object> hashConfig, Clock clock, double initialRecoveryLevel, double ringRampFactor, double highWaterMark, double lowWaterMark, double globalStepUp, double globalStepDown, long minCallCountHighWaterMark, long minCallCountLowWaterMark, double hashRingPointCleanUpRate, String consistentHashAlgorithm, int numProbes, String path, double quarantineMaxPercent, ScheduledExecutorService executorService, HealthCheckOperations healthCheckOperations, String healthCheckMethod, String healthCheckPath, long quarantineLatency) {
        this._updateIntervalMs = updateIntervalMs;
        this._updateOnlyAtInterval = updateOnlyAtInterval;
        this._pointsPerWeight = pointsPerWeight;
        this._hashMethod = hashMethod;
        this._hashConfig = Collections.unmodifiableMap(hashConfig);
        this._clock = clock;
        this._initialRecoveryLevel = initialRecoveryLevel;
        this._ringRampFactor = ringRampFactor;
        this._highWaterMark = highWaterMark;
        this._lowWaterMark = lowWaterMark;
        this._globalStepUp = globalStepUp;
        this._globalStepDown = globalStepDown;
        this._minClusterCallCountHighWaterMark = minCallCountHighWaterMark;
        this._minClusterCallCountLowWaterMark = minCallCountLowWaterMark;
        this._hashRingPointCleanUpRate = hashRingPointCleanUpRate;
        this._consistentHashAlgorithm = consistentHashAlgorithm;
        this._numProbes = numProbes;
        this._servicePath = path;
        this._quarantineMaxPercent = quarantineMaxPercent;
        this._executorService = executorService;
        this._healthCheckOperations = healthCheckOperations;
        this._healthCheckMethod = healthCheckMethod;
        this._healthCheckPath = healthCheckPath;
        this._quarantineLatency = quarantineLatency;
    }

    public static DegraderLoadBalancerStrategyConfig createHttpConfigFromMap(Map<String, Object> map) {
        return DegraderLoadBalancerStrategyConfig.createHttpConfigFromMap(map, null, null);
    }

    public static DegraderLoadBalancerStrategyConfig createHttpConfigFromMap(Map<String, Object> map, HealthCheckOperations healthCheckOperations, ScheduledExecutorService overrideExecutorService) {
        Clock clock = (Clock)MapUtil.getWithDefault(map, (Object)"clock", (Object)DEFAULT_CLOCK, Clock.class);
        Long updateIntervalMs = (Long)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.updateIntervalMs", (Object)5000L, Long.class);
        Boolean updateOnlyAtInterval = (Boolean)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.updateOnlyAtInterval", (Object)false, Boolean.class);
        Integer pointsPerWeight = (Integer)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.pointsPerWeight", (Object)100, Integer.class);
        String hashMethod = (String)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.hashMethod", null, String.class);
        Long minClusterCallCountHighWaterMark = (Long)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.clusterMinCallCount.highWaterMark", (Object)10L, Long.class);
        Long minClusterCallCountLowWaterMark = (Long)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.clusterMinCallCount.lowWaterMark", (Object)10L, Long.class);
        Double initialRecoveryLevel = (Double)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.initialRecoveryLevel", (Object)0.01, Double.class);
        Double ringRampFactor = (Double)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.ringRampFactor", (Object)1.0, Double.class);
        Double highWaterMark = (Double)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.highWaterMark", (Object)3000.0, Double.class);
        Double lowWaterMark = (Double)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.lowWaterMark", (Object)500.0, Double.class);
        Double globalStepUp = (Double)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.globalStepUp", (Object)0.2, Double.class);
        Double globalStepDown = (Double)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.globalStepDown", (Object)0.2, Double.class);
        Object obj = MapUtil.getWithDefault(map, (Object)"http.loadBalancer.hashConfig", Collections.emptyMap(), Map.class);
        Map hashConfig = (Map)obj;
        Double hashRingPointCleanUpRate = (Double)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.hashRingPointCleanupRate", (Object)0.2, Double.class);
        String consistentHashAlgorithm = (String)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.consistentHashAlgorithm", null, String.class);
        Integer numProbes = (Integer)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.consistentHashNumProbes", (Object)21);
        String servicePath = (String)MapUtil.getWithDefault(map, (Object)"path", null, String.class);
        Double quarantineMaxPercent = (Double)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.quarantine.maxPercent", (Object)0.0, Double.class);
        if (quarantineMaxPercent > 0.5) {
            quarantineMaxPercent = 0.5;
            _log.warn("MaxPercent value {} is too high. Changed it to {}", (Object)quarantineMaxPercent, (Object)0.5);
        }
        ScheduledExecutorService executorService = (ScheduledExecutorService)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.quarantine.executorService", null, ScheduledExecutorService.class);
        String method = (String)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.quarantine.method", (Object)DEFAULT_QUARANTINE_METHOD, String.class);
        Long quarantineLatency = (Long)MapUtil.getWithDefault(map, (Object)"http.loadBalancer.quarantine.latency", (Object)100L, Long.class);
        String healthCheckMethod = method;
        String healthCheckPath = null;
        int idx = method.indexOf(58);
        if (idx != -1) {
            healthCheckMethod = method.substring(0, idx);
            healthCheckPath = method.substring(idx + 1);
        }
        if (healthCheckMethod.isEmpty()) {
            healthCheckMethod = DEFAULT_QUARANTINE_METHOD;
        }
        return new DegraderLoadBalancerStrategyConfig(updateIntervalMs, updateOnlyAtInterval, pointsPerWeight, hashMethod, hashConfig, clock, initialRecoveryLevel, ringRampFactor, highWaterMark, lowWaterMark, globalStepUp, globalStepDown, minClusterCallCountHighWaterMark, minClusterCallCountLowWaterMark, hashRingPointCleanUpRate, consistentHashAlgorithm, numProbes, servicePath, quarantineMaxPercent, overrideExecutorService != null ? overrideExecutorService : executorService, healthCheckOperations, healthCheckMethod, healthCheckPath, quarantineLatency);
    }

    public long getUpdateIntervalMs() {
        return this._updateIntervalMs;
    }

    public int getPointsPerWeight() {
        return this._pointsPerWeight;
    }

    public long getMinClusterCallCountHighWaterMark() {
        return this._minClusterCallCountHighWaterMark;
    }

    public String getHashMethod() {
        return this._hashMethod;
    }

    public Map<String, Object> getHashConfig() {
        return this._hashConfig;
    }

    public long getMinClusterCallCountLowWaterMark() {
        return this._minClusterCallCountLowWaterMark;
    }

    public Clock getClock() {
        return this._clock;
    }

    public double getInitialRecoveryLevel() {
        return this._initialRecoveryLevel;
    }

    public double getRingRampFactor() {
        return this._ringRampFactor;
    }

    public double getHighWaterMark() {
        return this._highWaterMark;
    }

    public double getLowWaterMark() {
        return this._lowWaterMark;
    }

    public double getGlobalStepUp() {
        return this._globalStepUp;
    }

    public double getGlobalStepDown() {
        return this._globalStepDown;
    }

    public boolean isUpdateOnlyAtInterval() {
        return this._updateOnlyAtInterval;
    }

    public double getHashRingPointCleanUpRate() {
        return this._hashRingPointCleanUpRate;
    }

    public String getConsistentHashAlgorithm() {
        return this._consistentHashAlgorithm;
    }

    public int getNumProbes() {
        return this._numProbes;
    }

    public String getServicePath() {
        return this._servicePath;
    }

    public double getQuarantineMaxPercent() {
        return this._quarantineMaxPercent;
    }

    public ScheduledExecutorService getExecutorService() {
        return this._executorService;
    }

    public HealthCheckOperations getHealthCheckOperations() {
        return this._healthCheckOperations;
    }

    public String getHealthCheckMethod() {
        return this._healthCheckMethod;
    }

    public String getHealthCheckPath() {
        return this._healthCheckPath;
    }

    public long getQuarantineLatency() {
        return this._quarantineLatency;
    }

    public String toString() {
        return "DegraderLoadBalancerStrategyConfig [_highWaterMark=" + this._highWaterMark + ", _lowWaterMark=" + this._lowWaterMark + ", _initialRecoveryLevel=" + this._initialRecoveryLevel + ", _ringRampFactor=" + this._ringRampFactor + ", _globalStepUp=" + this._globalStepUp + ", _globalStepDown=" + this._globalStepDown + ", _pointsPerWeight=" + this._pointsPerWeight + "]";
    }
}

