/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.event;

import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.event.PropertyEventPublisher;
import com.linkedin.d2.discovery.event.PropertyEventSubscriber;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEventBusImpl<T>
implements PropertyEventBus<T> {
    private final PropertyEventThread _thread;
    private PropertyEventPublisher<T> _publisher;
    private final Map<String, T> _properties = new HashMap<String, T>();
    private final Map<String, List<PropertyEventSubscriber<T>>> _subscribers = new HashMap<String, List<PropertyEventSubscriber<T>>>();
    private final List<PropertyEventSubscriber<T>> _allPropertySubscribers = new ArrayList<PropertyEventSubscriber<T>>();
    private static final Logger _log = LoggerFactory.getLogger(PropertyEventBusImpl.class);

    public PropertyEventBusImpl(ExecutorService executorService) {
        this._thread = new PropertyEventExecutor("PropertyEventBusImpl PropertyEventThread", executorService);
    }

    public PropertyEventBusImpl(ExecutorService executorService, PropertyEventPublisher<T> publisher) {
        this(executorService);
        this._publisher = publisher;
        this._publisher.setBus(this);
    }

    @Override
    public void register(final PropertyEventSubscriber<T> listener) {
        this._thread.send(new PropertyEventThread.PropertyEvent("PropertyEventBus.registerAll"){

            @Override
            public void innerRun() {
                PropertyEventBusImpl.this._allPropertySubscribers.add(listener);
            }
        });
    }

    @Override
    public void unregister(final PropertyEventSubscriber<T> listener) {
        this._thread.send(new PropertyEventThread.PropertyEvent("PropertyEventBus.unregisterAll"){

            @Override
            public void innerRun() {
                PropertyEventBusImpl.this._allPropertySubscribers.remove(listener);
            }
        });
    }

    @Override
    public void register(final Set<String> propertyNames, final PropertyEventSubscriber<T> subscriber) {
        this._thread.send(new PropertyEventThread.PropertyEvent("PropertyEventBus.register " + propertyNames){

            @Override
            public void innerRun() {
                for (String prop : propertyNames) {
                    boolean notifyPublisher = false;
                    boolean initialized = PropertyEventBusImpl.this._properties.containsKey(prop);
                    ArrayList<PropertyEventSubscriber> listeners = (ArrayList<PropertyEventSubscriber>)PropertyEventBusImpl.this._subscribers.get(prop);
                    if (listeners == null) {
                        listeners = new ArrayList<PropertyEventSubscriber>();
                        PropertyEventBusImpl.this._subscribers.put(prop, listeners);
                    }
                    if (listeners.isEmpty()) {
                        notifyPublisher = true;
                    }
                    listeners.add(subscriber);
                    if (initialized) {
                        subscriber.onInitialize(prop, PropertyEventBusImpl.this._properties.get(prop));
                    }
                    if (!notifyPublisher) continue;
                    PropertyEventBusImpl.this._publisher.startPublishing(prop);
                }
            }
        });
    }

    @Override
    public void unregister(final Set<String> propertyNames, final PropertyEventSubscriber<T> subscriber) {
        this._thread.send(new PropertyEventThread.PropertyEvent("PropertyEventBus.unregister " + propertyNames){

            @Override
            public void innerRun() {
                for (String prop : propertyNames) {
                    List subscribers = (List)PropertyEventBusImpl.this._subscribers.get(prop);
                    if (subscribers == null) continue;
                    subscribers.remove(subscriber);
                    if (!subscribers.isEmpty()) continue;
                    PropertyEventBusImpl.this._properties.remove(prop);
                    PropertyEventBusImpl.this._publisher.stopPublishing(prop);
                }
            }
        });
    }

    @Override
    public void setPublisher(final PropertyEventPublisher<T> publisher) {
        this._thread.send(new PropertyEventThread.PropertyEvent("PropertyEventBus.setPublisher"){

            @Override
            public void innerRun() {
                if (PropertyEventBusImpl.this._publisher != null) {
                    for (String propertyName : PropertyEventBusImpl.this._subscribers.keySet()) {
                        PropertyEventBusImpl.this._publisher.stopPublishing(propertyName);
                    }
                }
                PropertyEventBusImpl.this._publisher = publisher;
                PropertyEventBusImpl.this._publisher.setBus(PropertyEventBusImpl.this);
                for (String propertyName : PropertyEventBusImpl.this._subscribers.keySet()) {
                    PropertyEventBusImpl.this._publisher.startPublishing(propertyName);
                }
            }
        });
    }

    @Override
    public void publishInitialize(final String prop, final T value) {
        if (value == null) {
            _log.warn("Received a null event during publishInitialize for String prop = " + prop + ". Still publishing the null event.");
        }
        this._thread.send(new PropertyEventThread.PropertyEvent("PropertyEventBus.publishInitialize " + prop){

            @Override
            public void innerRun() {
                boolean doAdd = PropertyEventBusImpl.this._properties.containsKey(prop);
                PropertyEventBusImpl.this._properties.put(prop, value);
                List waiters = PropertyEventBusImpl.this.subscribers(prop);
                for (PropertyEventSubscriber waiter : waiters) {
                    if (doAdd) {
                        waiter.onAdd(prop, value);
                        continue;
                    }
                    waiter.onInitialize(prop, value);
                }
            }
        });
    }

    @Override
    public void publishAdd(final String prop, final T value) {
        if (value == null) {
            _log.warn("Received a null event during publishAdd for String prop = " + prop + ". Still publishing the null event.");
        }
        this._thread.send(new PropertyEventThread.PropertyEvent("PropertyEventBus.publishAdd " + prop){

            @Override
            public void innerRun() {
                if (PropertyEventBusImpl.this._properties.containsKey(prop)) {
                    PropertyEventBusImpl.this._properties.put(prop, value);
                    for (PropertyEventSubscriber subscriber : PropertyEventBusImpl.this.subscribers(prop)) {
                        subscriber.onAdd(prop, value);
                    }
                }
            }
        });
    }

    @Override
    public void publishRemove(final String prop) {
        this._thread.send(new PropertyEventThread.PropertyEvent("PropertyEventBus.publishRemove " + prop){

            @Override
            public void innerRun() {
                if (PropertyEventBusImpl.this._properties.containsKey(prop)) {
                    PropertyEventBusImpl.this._properties.put(prop, null);
                    for (PropertyEventSubscriber subscriber : PropertyEventBusImpl.this.subscribers(prop)) {
                        subscriber.onRemove(prop);
                    }
                }
            }
        });
    }

    private List<PropertyEventSubscriber<T>> subscribers(String prop) {
        List<PropertyEventSubscriber<T>> subscribers = this._subscribers.get(prop);
        if (subscribers == null) {
            return this._allPropertySubscribers;
        }
        if (this._allPropertySubscribers.isEmpty()) {
            return subscribers;
        }
        ArrayList<PropertyEventSubscriber<T>> all = new ArrayList<PropertyEventSubscriber<T>>(subscribers.size() + this._allPropertySubscribers.size());
        all.addAll(this._allPropertySubscribers);
        all.addAll(subscribers);
        return all;
    }

    public PropertyEventPublisher<T> getPublisher() {
        return this._publisher;
    }

    private class PropertyEventExecutor
    extends PropertyEventThread {
        private final ExecutorService _executor;

        public PropertyEventExecutor(String name, ExecutorService executor) {
            super(name);
            this._executor = executor;
        }

        @Override
        public boolean send(PropertyEventThread.PropertyEvent message) {
            this._executor.execute(message);
            return true;
        }
    }
}

