/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPermanentStore;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaWriteZooKeeperPermanentStore<T>
extends ZooKeeperPermanentStore<T> {
    private static final Logger _log = LoggerFactory.getLogger(DeltaWriteZooKeeperPermanentStore.class);

    public DeltaWriteZooKeeperPermanentStore(ZKConnection client, PropertySerializer<T> serializer, String path) {
        super(client, serializer, path);
    }

    @Override
    protected Callback<None> getExistsCallBack(String listenTo, final T discoveryProperties, final Callback<None> callback) {
        final String path = this.getPath(listenTo);
        final AsyncCallback.StatCallback dataCallback = new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        callback.onSuccess((Object)None.none());
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        };
        final AsyncCallback.DataCallback getDataCallback = new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object context, byte[] bytes, Stat stat) {
                _log.debug("Data callback got rc {} for path {}", (Object)rc, (Object)path);
                KeeperException.Code result = KeeperException.Code.get((int)rc);
                switch (result) {
                    case OK: {
                        Object propertiesInStore = null;
                        if (bytes != null) {
                            try {
                                propertiesInStore = DeltaWriteZooKeeperPermanentStore.this._serializer.fromBytes(bytes);
                            }
                            catch (PropertySerializationException e) {
                                _log.warn("Unable to de-serialize properties for {}, overwriting", (Object)path, (Object)e);
                            }
                        }
                        if (propertiesInStore == null || !propertiesInStore.equals(discoveryProperties)) {
                            _log.debug("Updating value for {}", (Object)path);
                            DeltaWriteZooKeeperPermanentStore.this._zk.setData(path, DeltaWriteZooKeeperPermanentStore.this._serializer.toBytes(discoveryProperties), -1, dataCallback, null);
                            break;
                        }
                        _log.debug("Node is up to date, skipping write for {}", (Object)path);
                        callback.onSuccess((Object)None.none());
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)result));
                    }
                }
            }
        };
        return new Callback<None>(){

            public void onSuccess(None none) {
                DeltaWriteZooKeeperPermanentStore.this._zk.getData(path, false, getDataCallback, null);
            }

            public void onError(Throwable e) {
                _log.debug("Exist : failed for path {}", (Object)path);
                callback.onError(e);
            }
        };
    }
}

