/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.event.PropertyEventPublisher;
import com.linkedin.d2.discovery.stores.PropertyStore;
import com.linkedin.d2.discovery.stores.PropertyStoreException;
import com.linkedin.d2.discovery.stores.util.AbstractPropertyStoreAsync;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.d2.discovery.util.Stats;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZooKeeperStore<T>
extends AbstractPropertyStoreAsync<T>
implements PropertyEventPublisher<T>,
PropertyStore<T> {
    private static final Logger _log = LoggerFactory.getLogger(ZooKeeperStore.class);
    protected PropertyEventBus<T> _eventBus;
    protected final ZKConnection _zkConn;
    protected final String _path;
    protected final PropertySerializer<T> _serializer;
    protected final Stats _getStats = new Stats(60000L);
    protected final Stats _putStats = new Stats(60000L);
    protected final Stats _removeStats = new Stats(60000L);
    protected final Stats _registerStats = new Stats(60000L);
    protected final Stats _unregisterStats = new Stats(60000L);
    protected ZooKeeper _zk;

    public ZooKeeperStore(ZKConnection client, PropertySerializer<T> serializer, String path) {
        this._zkConn = client;
        this._path = path;
        this._serializer = serializer;
    }

    @Override
    public void start(Callback<None> callback) {
        this._zk = this._zkConn.getZooKeeper();
        this._zkConn.ensurePersistentNodeExists(this._path, callback);
    }

    @Override
    public void setBus(PropertyEventBus<T> bus) {
        this._eventBus = bus;
    }

    @Override
    public void shutdown(Callback<None> callback) {
        LogUtil.debug(_log, "shutting down");
        callback.onSuccess((Object)None.none());
        LogUtil.info(_log, "shutdown complete");
    }

    public static String getListenTo(String path) {
        return new File(path).getName();
    }

    public ZKConnection getClient() {
        return this._zkConn;
    }

    protected String getPath(String listenTo) {
        if (!this._path.equals("/")) {
            return this._path + "/" + listenTo;
        }
        return this._path + listenTo;
    }

    protected String getPropertyForPath(String path) {
        if (path.startsWith(this._path + "/")) {
            return path.substring(this._path.length() + 1);
        }
        if (this._path.equals("/")) {
            return path.substring(1);
        }
        throw new IllegalArgumentException(path + " is not under " + this._path);
    }

    public String getPath() {
        return this._path;
    }

    public PropertySerializer<T> getSerializer() {
        return this._serializer;
    }

    public List<String> ls() throws PropertyStoreException {
        try {
            return this._zk.getChildren(this._path, false);
        }
        catch (Exception e) {
            throw new PropertyStoreException("Failed to list children of path " + this._path, e);
        }
    }

    public long getGetCount() {
        return this._getStats.getCount();
    }

    public long getPutCount() {
        return this._putStats.getCount();
    }

    public long getRemoveCount() {
        return this._removeStats.getCount();
    }

    public long getRegisterCount() {
        return this._registerStats.getCount();
    }

    public long getUnregisterCount() {
        return this._unregisterStats.getCount();
    }

    protected abstract class ZKStoreWatcher
    implements Watcher {
        private final Object _mutex = new Object();
        private final Set<String> _watches = new HashSet<String>();

        protected ZKStoreWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addWatch(String propertyName) {
            Object object = this._mutex;
            synchronized (object) {
                this._watches.add(propertyName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelWatch(String propertyName) {
            Object object = this._mutex;
            synchronized (object) {
                this._watches.remove(propertyName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getWatchCount() {
            Object object = this._mutex;
            synchronized (object) {
                return this._watches.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelAllWatches() {
            Object object = this._mutex;
            synchronized (object) {
                this._watches.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean containsWatch(String prop) {
            Object object = this._mutex;
            synchronized (object) {
                if (this._watches.contains(prop)) {
                    return true;
                }
            }
            return false;
        }

        public final void process(WatchedEvent watchedEvent) {
            _log.debug("Session {}: Received watch type {} for path {} ", new Object[]{ZooKeeperStore.this._zk.getSessionId(), watchedEvent.getType(), watchedEvent.getPath()});
            Watcher.Event.EventType type = watchedEvent.getType();
            if (type != Watcher.Event.EventType.None) {
                String path = this.watchedPropertyPath(watchedEvent.getPath());
                if (path == null) {
                    _log.debug("Ignoring watch for path {}: {}", (Object)path, (Object)watchedEvent);
                    return;
                }
                _log.debug("processing watch for path: {}", (Object)path);
                this.processWatch(ZooKeeperStore.this.getPropertyForPath(path), watchedEvent);
            }
        }

        protected String watchedPropertyPath(String inputPath) {
            if (this.containsWatch(ZooKeeperStore.this.getPropertyForPath(inputPath))) {
                return inputPath;
            }
            return null;
        }

        protected abstract void processWatch(String var1, WatchedEvent var2);
    }
}

