/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.servers.ZooKeeperAnnouncer;
import com.linkedin.d2.balancer.util.JacksonUtil;
import com.linkedin.d2.discovery.stores.PropertyStoreException;
import com.linkedin.d2.jmx.ZooKeeperAnnouncerJmxMXBean;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ZooKeeperAnnouncerJmx
implements ZooKeeperAnnouncerJmxMXBean {
    private final ZooKeeperAnnouncer _announcer;

    public ZooKeeperAnnouncerJmx(ZooKeeperAnnouncer announcer) {
        this._announcer = announcer;
    }

    @Override
    public void reset() throws PropertyStoreException {
        FutureCallback callback = new FutureCallback();
        this._announcer.reset((Callback<None>)callback);
        try {
            callback.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new PropertyStoreException(e);
        }
    }

    @Override
    public void markUp() throws PropertyStoreException {
        FutureCallback callback = new FutureCallback();
        this._announcer.markUp((Callback<None>)callback);
        try {
            callback.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new PropertyStoreException(e);
        }
    }

    @Override
    public void markDown() throws PropertyStoreException {
        FutureCallback callback = new FutureCallback();
        this._announcer.markDown((Callback<None>)callback);
        try {
            callback.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new PropertyStoreException(e);
        }
    }

    @Override
    public String getCluster() {
        return this._announcer.getCluster();
    }

    @Override
    public void setCluster(String cluster) {
        this._announcer.setCluster(cluster);
    }

    @Override
    public String getUri() {
        return this._announcer.getUri();
    }

    @Override
    public void setUri(String uri) {
        this._announcer.setUri(uri);
    }

    @Override
    public void setWeight(double weight) {
        this._announcer.setWeight(weight);
    }

    @Override
    public void setPartitionDataUsingJson(String partitionDataJson) throws IOException {
        Map rawObject = (Map)JacksonUtil.getObjectMapper().readValue(partitionDataJson, HashMap.class);
        HashMap<Integer, PartitionData> partitionDataMap = new HashMap<Integer, PartitionData>();
        for (Map.Entry entry : rawObject.entrySet()) {
            PartitionData data = new PartitionData((Double)entry.getValue());
            partitionDataMap.put((Integer)entry.getKey(), data);
        }
        this._announcer.setPartitionData(partitionDataMap);
    }

    @Override
    public void setPartitionData(Map<Integer, PartitionData> partitionData) {
        this._announcer.setPartitionData(partitionData);
    }

    @Override
    public Map<Integer, PartitionData> getPartitionData() {
        return this._announcer.getPartitionData();
    }
}

