/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.stores.PropertyStoreException;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperStore;
import com.linkedin.d2.jmx.ZooKeeperStoreJmxMBean;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ZooKeeperStoreJmx<T>
implements ZooKeeperStoreJmxMBean {
    private final ZooKeeperStore<T> _store;

    public ZooKeeperStoreJmx(ZooKeeperStore<T> store) {
        this._store = store;
    }

    @Override
    public long getGetCount() {
        return this._store.getGetCount();
    }

    @Override
    public long getPutCount() {
        return this._store.getPutCount();
    }

    @Override
    public long getRemoveCount() {
        return this._store.getRemoveCount();
    }

    @Override
    public String getPath() {
        return this._store.getPath();
    }

    @Override
    public List<String> ls() throws PropertyStoreException {
        List<String> ls = this._store.ls();
        return ls != null ? ls : null;
    }

    @Override
    public String get(String listenTo) throws PropertyStoreException {
        return this._store.get(listenTo) + "";
    }

    @Override
    public void put(String listenTo, String discoveryProperties) throws PropertyStoreException {
        try {
            this._store.put(listenTo, this._store.getSerializer().fromBytes(discoveryProperties.getBytes("UTF-8")));
        }
        catch (PropertySerializationException e) {
            throw new PropertyStoreException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 should never fail", e);
        }
    }

    @Override
    public void remove(String listenTo) throws PropertyStoreException {
        this._store.remove(listenTo);
    }

    @Override
    public long getRegisterCount() {
        return this._store.getRegisterCount();
    }

    @Override
    public long getUnregisterCount() {
        return this._store.getUnregisterCount();
    }
}

