/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.gobblin.tunnel;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * A convenient, trackable, easy-to-cleanup wrapper around threads.
 *
 * @author kkandekar@linkedin.com
 */
abstract class EasyThread extends Thread {
  protected static final Logger LOG = LoggerFactory.getLogger(EasyThread.class);
  final static Set<EasyThread> ALL_THREADS = Collections.synchronizedSet(new HashSet<EasyThread>());

  EasyThread startThread() {
    setDaemon(true);
    start();
    ALL_THREADS.add(this);
    return this;
  }

  @Override
  public void run() {
    try {
      runQuietly();
    } catch (Exception e) {
      LOG.info("Exception in EasyThread#run", e);
    }
  }

  abstract void runQuietly() throws Exception;
}
