/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.util;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpHeaders;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public final class HttpHeadersUtil {
    private static final Supplier<Pattern> HEADER_MASK_PATTERNS = SupplierUtil.memoized(() -> Pattern.compile(".*(password|cred|cert|key|secret|token|auth|signat).*", 2));

    private HttpHeadersUtil() {
    }

    public static void trace(@NonNull Logger log, @NonNull HttpHeaders httpHeaders) {
        HttpHeadersUtil.trace(log, httpHeaders.names(), httpHeaders::getAll);
    }

    public static void trace(@NonNull Logger log, @NonNull Set<String> names, @NonNull Function<String, List<String>> getAllHeaders) {
        names.forEach(name -> HttpHeadersUtil.trace(log, name, getAllHeaders));
    }

    public static void trace(@NonNull Logger log, @NonNull String name, @NonNull Function<String, List<String>> getAllHeaders) {
        boolean isMasked = HEADER_MASK_PATTERNS.get().matcher(name).matches();
        List<String> all = getAllHeaders.apply(name);
        if (all.size() > 1) {
            for (String value : all) {
                String maskedValue = isMasked ? HttpHeadersUtil.mask(value) : value;
                log.trace("{}: {}", (Object)name, (Object)maskedValue);
            }
        } else if (!all.isEmpty()) {
            String maskedValue = isMasked ? HttpHeadersUtil.mask(all.get(0)) : all.get(0);
            log.trace("{}: {}", (Object)name, (Object)maskedValue);
        }
    }

    @Nullable
    private static String mask(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return "*MASKED*";
    }
}

