/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.grails.datastore.gorm.jdbc.DatabaseDriver;
import org.grails.datastore.gorm.jdbc.RelaxedDataBinder;
import org.grails.datastore.mapping.core.exceptions.ConfigurationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.util.ClassUtils;

public class DataSourceBuilder {
    private static final String[] DATA_SOURCE_TYPE_NAMES = new String[]{"org.apache.tomcat.jdbc.pool.DataSource", "com.zaxxer.hikari.HikariDataSource", "org.apache.commons.dbcp.BasicDataSource", "org.apache.commons.dbcp2.BasicDataSource", "org.springframework.jdbc.datasource.DriverManagerDataSource"};
    private Class<? extends DataSource> type;
    private ClassLoader classLoader;
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean pooled = true;
    private boolean readOnly = false;

    public static DataSourceBuilder create() {
        return new DataSourceBuilder(null);
    }

    public static DataSourceBuilder create(ClassLoader classLoader) {
        return new DataSourceBuilder(classLoader);
    }

    public DataSourceBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public DataSource build() {
        Class<? extends DataSource> type = this.getType();
        DataSource result = BeanUtils.instantiateClass(type);
        this.maybeGetDriverClassName();
        this.bind(result);
        return result;
    }

    private void maybeGetDriverClassName() {
        if (!this.properties.containsKey("driverClassName") && this.properties.containsKey("url")) {
            String url = this.properties.get("url");
            String driverClass = DatabaseDriver.fromJdbcUrl(url).getDriverClassName();
            this.properties.put("driverClassName", driverClass);
            this.properties.put("driver", driverClass);
        }
    }

    private void bind(DataSource result) {
        if (this.properties.containsKey("dbProperties")) {
            this.coerceDbProperties();
        }
        MutablePropertyValues properties = new MutablePropertyValues(this.properties);
        new RelaxedDataBinder(result).withAlias("url", "jdbcUrl").withAlias("username", "user").bind(properties);
    }

    public DataSourceBuilder properties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    private void coerceDbProperties() {
        Map<String, String> propertiesMap = this.properties;
        String dbPropertiesObject = propertiesMap.get("dbProperties");
        if (dbPropertiesObject instanceof Map) {
            Map dbProperties = (Map)((Object)dbPropertiesObject);
            Properties properties = new Properties();
            for (Object key : dbProperties.keySet()) {
                Object value = dbProperties.get(key);
                if (value == null) continue;
                properties.put(key.toString(), value.toString());
            }
            propertiesMap.put("dbProperties", (String)((Object)properties));
        }
    }

    public DataSourceBuilder type(Class<? extends DataSource> type) {
        this.type = type;
        return this;
    }

    public DataSourceBuilder url(String url) {
        this.properties.put("url", url);
        return this;
    }

    public DataSourceBuilder driverClassName(String driverClassName) {
        this.properties.put("driverClassName", driverClassName);
        return this;
    }

    public DataSourceBuilder username(String username) {
        this.properties.put("username", username);
        return this;
    }

    public DataSourceBuilder password(String password) {
        this.properties.put("password", password);
        return this;
    }

    public Class<? extends DataSource> findType() {
        if (this.type != null) {
            return this.type;
        }
        if (!this.pooled) {
            if (this.readOnly) {
                return ReadOnlyDriverManagerDataSource.class;
            }
            return DriverManagerDataSource.class;
        }
        for (String name : DATA_SOURCE_TYPE_NAMES) {
            try {
                return ClassUtils.forName(name, this.classLoader);
            }
            catch (Exception exception) {
            }
        }
        throw new ConfigurationException("No connection pool implementation found on classpath (example commons-dbcp, tomcat-pool etc.)");
    }

    private Class<? extends DataSource> getType() {
        Class<? extends DataSource> type = this.findType();
        if (type != null) {
            return type;
        }
        throw new IllegalStateException("No supported DataSource type found");
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected static class ReadOnlyDriverManagerDataSource
    extends DriverManagerDataSource {
        protected ReadOnlyDriverManagerDataSource() {
        }

        protected Connection getConnectionFromDriverManager(String url, Properties props) throws SQLException {
            Connection connection = super.getConnectionFromDriverManager(url, props);
            connection.setReadOnly(true);
            return connection;
        }
    }
}

