/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.proxy;

import java.lang.reflect.Method;
import org.grails.datastore.mapping.proxy.GroovyObjectMethodHandler;

public abstract class EntityProxyMethodHandler
extends GroovyObjectMethodHandler {
    public static final String PROXY_PROPERTY = "proxy";
    public static final String PROXY_KEY_PROPERTY = "proxyKey";
    public static final String INITIALIZED_PROPERTY = "initialized";
    public static final String TARGET_PROPERTY = "target";
    public static final String IS_PROXY_METHOD = "isProxy";
    public static final String GET_PROXY_KEY_METHOD = "getProxyKey";
    public static final String GET_ID_METHOD = "getId";
    public static final String IS_INITIALIZED_METHOD = "isInitialized";
    public static final String INITIALIZE_METHOD = "initialize";
    public static final String GET_TARGET_METHOD = "getTarget";

    public EntityProxyMethodHandler(Class<?> proxyClass) {
        super(proxyClass);
    }

    @Override
    protected Object getPropertyBeforeResolving(Object self, String property) {
        if (property.equals(PROXY_PROPERTY)) {
            return true;
        }
        if (property.equals(PROXY_KEY_PROPERTY) || property.equals("id")) {
            return this.getProxyKey(self);
        }
        if (property.equals(INITIALIZED_PROPERTY)) {
            return this.isProxyInitiated(self);
        }
        if (property.equals(TARGET_PROPERTY)) {
            return this.getProxyTarget(self);
        }
        return super.getPropertyBeforeResolving(self, property);
    }

    @Override
    public Object invokeMethodBeforeResolving(Object self, String methodName, Object[] args) {
        Object result = this.invokeEntityProxyMethods(self, methodName, args);
        if (!this.wasHandled(result)) {
            return super.invokeMethodBeforeResolving(self, methodName, args);
        }
        return result;
    }

    @Override
    public Object handleInvocation(Object self, Method thisMethod, Object[] args) {
        Object result = this.invokeEntityProxyMethods(self, thisMethod.getName(), args);
        if (!this.wasHandled(result) && !this.wasHandled(result = super.handleInvocation(self, thisMethod, args))) {
            return this.handleInvocationFallback(self, thisMethod, args);
        }
        return result;
    }

    protected Object handleInvocationFallback(Object self, Method thisMethod, Object[] args) {
        return INVOKE_IMPLEMENTATION;
    }

    protected Object invokeEntityProxyMethods(Object self, String methodName, Object[] args) {
        if (methodName.equals(IS_PROXY_METHOD)) {
            return true;
        }
        if (methodName.equals(GET_PROXY_KEY_METHOD) || methodName.equals(GET_ID_METHOD)) {
            return this.getProxyKey(self);
        }
        if (methodName.equals(IS_INITIALIZED_METHOD)) {
            return this.isProxyInitiated(self);
        }
        if (methodName.equals(GET_TARGET_METHOD)) {
            return this.getProxyTarget(self);
        }
        if (methodName.equals(INITIALIZE_METHOD)) {
            this.initializeProxyTarget(self);
            return Void.class;
        }
        return INVOKE_IMPLEMENTATION;
    }

    protected void initializeProxyTarget(Object self) {
        this.getProxyTarget(self);
    }

    protected Object getProxyTarget(Object self) {
        return this.resolveDelegate(self);
    }

    protected abstract Object isProxyInitiated(Object var1);

    protected abstract Object getProxyKey(Object var1);
}

