/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.config;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class Configuration
extends LinkedHashMap<String, Object> {
    private final String path;
    private final String fileName;
    private final String templateKey;
    private final String environment;

    public Configuration(@NonNull String sourceSet, @NonNull String fileName, @NonNull String templateKey, @Nullable String environment2) {
        this.path = environment2 != null && environment2.equals("test") ? "src/" + sourceSet + "/resources/" : "grails-app/conf/";
        this.fileName = fileName;
        this.templateKey = templateKey;
        this.environment = environment2;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key != null) {
            return super.containsKey(key) || this.containsNested(key.toString());
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        if (key != null && this.containsKey(key)) {
            Object o = super.get(key);
            if (o != null) {
                return o;
            }
            return this.getNested(key.toString());
        }
        return null;
    }

    public Configuration addNested(String path, Object value) {
        if (StringUtils.isNotEmpty(path)) {
            String[] tokens = path.split("\\.");
            LinkedHashMap map = this;
            for (int i2 = 0; i2 < tokens.length; ++i2) {
                String token = tokens[i2];
                if (i2 == tokens.length - 1) {
                    map.put(token, value);
                    continue;
                }
                map = (LinkedHashMap)map.computeIfAbsent(token, key -> new LinkedHashMap(5));
            }
        }
        return this;
    }

    public Configuration addNested(Map<String, Object> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            values.forEach(this::addNested);
        }
        return this;
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public String getFileName() {
        return this.fileName;
    }

    @NonNull
    public String getFullPath(String extension) {
        return this.path + this.fileName + "." + extension;
    }

    @NonNull
    public String getTemplateKey() {
        return this.templateKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.templateKey.equals(that.templateKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.templateKey);
    }

    private boolean containsNested(String key) {
        if (key.indexOf(46) == -1) {
            return false;
        }
        String[] tokens = key.split("\\.");
        Map<String, Object> map = this;
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            if (!map.containsKey(token)) {
                return false;
            }
            Object o = map.get(token);
            if (i2 == tokens.length - 1) {
                return true;
            }
            if (!(o instanceof Map)) {
                return false;
            }
            map = (Map)o;
        }
        return true;
    }

    private Object getNested(String key) {
        if (key.indexOf(46) == -1) {
            return null;
        }
        String[] tokens = key.split("\\.");
        Map<String, Object> map = this;
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            if (!map.containsKey(token)) {
                return null;
            }
            Object o = map.get(token);
            if (i2 == tokens.length - 1) {
                return o;
            }
            if (!(o instanceof Map)) {
                return null;
            }
            map = (Map)o;
        }
        return null;
    }
}

