/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import grails.web.mapping.UrlMappingData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

public class DefaultUrlMappingData
implements UrlMappingData {
    private static final String CAPTURED_WILDCARD = "(*)";
    private static final String CAPTURED_DOUBLE_WILDCARD = "(**)";
    private static final String QUESTION_MARK = "?";
    private static final String SLASH = "/";
    private final String urlPattern;
    private final String[] logicalUrls;
    private final String[] tokens;
    private List<Boolean> optionalTokens = new ArrayList<Boolean>();
    private boolean hasOptionalExtension;

    public DefaultUrlMappingData(String urlPattern) {
        String configuredPattern;
        Assert.hasLength(urlPattern, "Argument [urlPattern] cannot be null or blank");
        Assert.isTrue(urlPattern.startsWith(SLASH), "Argument [urlPattern] is not a valid URL. It must start with '/' !");
        this.urlPattern = configuredPattern = this.configureUrlPattern(urlPattern);
        this.tokens = this.tokenizeUrlPattern(configuredPattern);
        ArrayList<String> urls = new ArrayList<String>();
        this.parseUrls(urls, this.tokens, this.optionalTokens);
        this.logicalUrls = urls.toArray(new String[urls.size()]);
    }

    @Override
    public boolean hasOptionalExtension() {
        return this.hasOptionalExtension;
    }

    private String[] tokenizeUrlPattern(String urlPattern) {
        return urlPattern.substring(1).split(SLASH);
    }

    private String configureUrlPattern(String urlPattern) {
        return urlPattern.replace("(*)**", CAPTURED_DOUBLE_WILDCARD);
    }

    private DefaultUrlMappingData(String urlPattern, String[] logicalUrls, String[] tokens, List<Boolean> optionalTokens) {
        this.urlPattern = urlPattern;
        this.logicalUrls = logicalUrls;
        this.tokens = tokens;
        this.optionalTokens = optionalTokens;
    }

    private void parseUrls(List<String> urls, String[] tokens, List<Boolean> optionalTokens) {
        StringBuilder buf = new StringBuilder();
        String optionalExtensionPattern = "(.(*))?";
        String optionalExtension = null;
        if (tokens.length > 0) {
            String lastToken = tokens[tokens.length - 1];
            this.hasOptionalExtension = lastToken.endsWith(optionalExtensionPattern);
            if (this.hasOptionalExtension) {
                int i2 = lastToken.indexOf(optionalExtensionPattern);
                optionalExtension = lastToken.substring(i2, lastToken.length());
                tokens[tokens.length - 1] = lastToken.substring(0, i2);
            }
        }
        for (int i3 = 0; i3 < tokens.length; ++i3) {
            String token = tokens[i3].trim();
            if (token.equals(SLASH)) continue;
            boolean isOptional = false;
            if (token.endsWith(QUESTION_MARK)) {
                if (optionalExtension != null) {
                    urls.add(buf.toString() + optionalExtension);
                } else {
                    urls.add(buf.toString());
                }
                buf.append(SLASH).append(token);
                isOptional = true;
            } else {
                buf.append(SLASH).append(token);
            }
            if (CAPTURED_WILDCARD.equals(token)) {
                if (isOptional) {
                    optionalTokens.add(Boolean.TRUE);
                } else {
                    optionalTokens.add(Boolean.FALSE);
                }
            }
            if (!CAPTURED_DOUBLE_WILDCARD.equals(token)) continue;
            optionalTokens.add(Boolean.TRUE);
        }
        if (optionalExtension != null) {
            urls.add(buf.toString() + optionalExtension);
        } else {
            urls.add(buf.toString());
        }
        Collections.reverse(urls);
    }

    @Override
    public String[] getTokens() {
        return this.tokens;
    }

    @Override
    public String[] getLogicalUrls() {
        return this.logicalUrls;
    }

    @Override
    public String getUrlPattern() {
        return this.urlPattern;
    }

    @Override
    public boolean isOptional(int index2) {
        if (index2 >= this.optionalTokens.size()) {
            return true;
        }
        return this.optionalTokens.get(index2).equals(Boolean.TRUE);
    }

    @Override
    public UrlMappingData createRelative(String path) {
        Assert.hasLength(path, "Argument [path] cannot be null or blank");
        String newPattern = this.urlPattern + this.configureUrlPattern(path);
        String[] tokens = this.tokenizeUrlPattern(newPattern);
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<Boolean> optionalTokens = new ArrayList<Boolean>();
        this.parseUrls(urls, tokens, optionalTokens);
        String[] logicalUrls = urls.toArray(new String[urls.size()]);
        return new DefaultUrlMappingData(newPattern, logicalUrls, tokens, optionalTokens);
    }
}

