/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.job.local;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.gravitino.job.JobTemplate;
import org.apache.gravitino.job.ShellJobTemplate;
import org.apache.gravitino.job.local.LocalProcessBuilder;

public class ShellProcessBuilder
extends LocalProcessBuilder {
    protected ShellProcessBuilder(ShellJobTemplate shellJobTemplate, Map<String, String> configs) {
        super((JobTemplate)shellJobTemplate, configs);
    }

    @Override
    public Process start() {
        ShellJobTemplate shellJobTemplate = (ShellJobTemplate)this.jobTemplate;
        File executableFile = new File(shellJobTemplate.executable());
        if (!executableFile.canExecute()) {
            executableFile.setExecutable(true);
        }
        ArrayList commandList = Lists.newArrayList((Object[])new String[]{shellJobTemplate.executable()});
        commandList.addAll(shellJobTemplate.arguments());
        ProcessBuilder builder = new ProcessBuilder(commandList);
        builder.directory(this.workingDirectory);
        builder.environment().putAll(shellJobTemplate.environments());
        File outputFile = new File(this.workingDirectory, "output.log");
        File errorFile = new File(this.workingDirectory, "error.log");
        builder.redirectOutput(outputFile);
        builder.redirectError(errorFile);
        try {
            return builder.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start shell process", e);
        }
    }
}

