/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License. See accompanying LICENSE file.
 */
package org.apache.hadoop.security.authentication.util;

import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceStability;

/**
 * Helper class for creating StringSignerSecretProviders in unit tests
 */
@InterfaceStability.Unstable
@VisibleForTesting
public class StringSignerSecretProviderCreator {
  /**
   * @return a new StringSignerSecretProvider
   * @throws Exception
   */
  public static StringSignerSecretProvider newStringSignerSecretProvider()
      throws Exception {
    return new StringSignerSecretProvider();
  }
}
