/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.domain;

import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverterToString;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;

public class DomainRowKey {
    private final String clusterId;
    private final String domainId;
    private final DomainRowKeyConverter domainIdKeyConverter = new DomainRowKeyConverter();

    public DomainRowKey(String clusterId, String domainId) {
        this.clusterId = clusterId;
        this.domainId = domainId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public byte[] getRowKey() {
        return this.domainIdKeyConverter.encode(this);
    }

    public static DomainRowKey parseRowKey(byte[] rowKey) {
        return new DomainRowKeyConverter().decode(rowKey);
    }

    public String getRowKeyAsString() {
        return this.domainIdKeyConverter.encodeAsString(this);
    }

    public static DomainRowKey parseRowKeyFromString(String encodedRowKey) {
        return new DomainRowKeyConverter().decodeFromString(encodedRowKey);
    }

    private static final class DomainRowKeyConverter
    implements KeyConverter<DomainRowKey>,
    KeyConverterToString<DomainRowKey> {
        private static final int[] SEGMENT_SIZES = new int[]{0, 0};

        private DomainRowKeyConverter() {
        }

        @Override
        public byte[] encode(DomainRowKey rowKey) {
            if (rowKey == null) {
                return Separator.EMPTY_BYTES;
            }
            byte[] cluster = Separator.encode(rowKey.getClusterId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] domainIdBytes = Separator.encode(rowKey.getDomainId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            return Separator.QUALIFIERS.join(cluster, domainIdBytes);
        }

        @Override
        public DomainRowKey decode(byte[] rowKey) {
            byte[][] rowKeyComponents = Separator.QUALIFIERS.split(rowKey, SEGMENT_SIZES);
            if (rowKeyComponents.length != 2) {
                throw new IllegalArgumentException("the row key is not valid for a domain id");
            }
            String clusterId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[0]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String domainId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[1]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            return new DomainRowKey(clusterId, domainId);
        }

        @Override
        public String encodeAsString(DomainRowKey key) {
            return TimelineReaderUtils.joinAndEscapeStrings((String[])new String[]{key.clusterId, key.domainId});
        }

        @Override
        public DomainRowKey decodeFromString(String encodedRowKey) {
            List split = TimelineReaderUtils.split((String)encodedRowKey);
            if (split == null || split.size() != 2) {
                throw new IllegalArgumentException("Invalid row key for domain id.");
            }
            return new DomainRowKey((String)split.get(0), (String)split.get(1));
        }
    }
}

