/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.CallableRaisingIOE;

public abstract class ExecutingStoreOperation<T>
extends AbstractStoreOperation
implements CallableRaisingIOE<T> {
    private final AtomicBoolean executed = new AtomicBoolean(false);

    protected ExecutingStoreOperation(StoreContext storeContext) {
        this(storeContext, storeContext.getActiveAuditSpan());
    }

    protected ExecutingStoreOperation(StoreContext storeContext, AuditSpan auditSpan) {
        super(storeContext, auditSpan);
    }

    public final T apply() throws IOException {
        return this.execute();
    }

    public abstract T execute() throws IOException;

    protected void executeOnlyOnce() {
        Preconditions.checkState((!this.executed.getAndSet(true) ? 1 : 0) != 0, (Object)"Operation attempted twice");
        this.activateAuditSpan();
    }
}

