/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSetters;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.ForwardingIOStatisticsStore;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestIOStatisticsSetters
extends AbstractHadoopTestBase {
    public static final String COUNTER = "counter";
    public static final String GAUGE = "gauge";
    public static final String MAXIMUM = "max";
    public static final String MINIMUM = "min";
    public static final String MEAN = "mean";
    private final IOStatisticsSetters ioStatistics;
    private final boolean createsNewEntries;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({"IOStatisticsSnapshot", new IOStatisticsSnapshot(), true}, {"IOStatisticsStore", TestIOStatisticsSetters.createTestStore(), false}, {"ForwardingIOStatisticsStore", new ForwardingIOStatisticsStore(TestIOStatisticsSetters.createTestStore()), false});
    }

    private static IOStatisticsStore createTestStore() {
        return IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{COUNTER}).withGauges(new String[]{GAUGE}).withMaximums(new String[]{MAXIMUM}).withMinimums(new String[]{MINIMUM}).withMeanStatistics(new String[]{MEAN}).build();
    }

    public TestIOStatisticsSetters(String source, IOStatisticsSetters ioStatisticsSetters, boolean createsNewEntries) {
        this.ioStatistics = ioStatisticsSetters;
        this.createsNewEntries = createsNewEntries;
    }

    @Test
    public void testCounter() throws Throwable {
        this.ioStatistics.setCounter(COUNTER, 1L);
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)this.ioStatistics, COUNTER).isEqualTo(1L);
        this.ioStatistics.setCounter(COUNTER, 2L);
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)this.ioStatistics, COUNTER).isEqualTo(2L);
        String unknown = "unknown";
        this.ioStatistics.setCounter("unknown", 3L);
        if (this.createsNewEntries) {
            IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)this.ioStatistics, "unknown").isEqualTo(3L);
        } else {
            ((MapAssert)Assertions.assertThat((Map)this.ioStatistics.counters()).describedAs("Counter map in {}", new Object[]{this.ioStatistics})).doesNotContainKey((Object)"unknown");
        }
    }

    @Test
    public void testMaximum() throws Throwable {
        this.ioStatistics.setMaximum(MAXIMUM, 1L);
        IOStatisticAssertions.assertThatStatisticMaximum((IOStatistics)this.ioStatistics, MAXIMUM).isEqualTo(1L);
        this.ioStatistics.setMaximum(MAXIMUM, 2L);
        IOStatisticAssertions.assertThatStatisticMaximum((IOStatistics)this.ioStatistics, MAXIMUM).isEqualTo(2L);
        this.ioStatistics.setMaximum("mm2", 3L);
    }

    @Test
    public void testMinimum() throws Throwable {
        this.ioStatistics.setMinimum(MINIMUM, 1L);
        IOStatisticAssertions.assertThatStatisticMinimum((IOStatistics)this.ioStatistics, MINIMUM).isEqualTo(1L);
        this.ioStatistics.setMinimum(MINIMUM, 2L);
        IOStatisticAssertions.assertThatStatisticMinimum((IOStatistics)this.ioStatistics, MINIMUM).isEqualTo(2L);
        this.ioStatistics.setMinimum("c2", 3L);
    }

    @Test
    public void testGauge() throws Throwable {
        this.ioStatistics.setGauge(GAUGE, 1L);
        IOStatisticAssertions.assertThatStatisticGauge((IOStatistics)this.ioStatistics, GAUGE).isEqualTo(1L);
        this.ioStatistics.setGauge(GAUGE, 2L);
        IOStatisticAssertions.assertThatStatisticGauge((IOStatistics)this.ioStatistics, GAUGE).isEqualTo(2L);
        this.ioStatistics.setGauge("g2", 3L);
    }

    @Test
    public void testMean() throws Throwable {
        MeanStatistic mean11 = new MeanStatistic(1L, 1L);
        this.ioStatistics.setMeanStatistic(MEAN, mean11);
        IOStatisticAssertions.assertThatStatisticMean((IOStatistics)this.ioStatistics, MEAN).isEqualTo((Object)mean11);
        MeanStatistic mean22 = new MeanStatistic(2L, 2L);
        this.ioStatistics.setMeanStatistic(MEAN, mean22);
        IOStatisticAssertions.assertThatStatisticMean((IOStatistics)this.ioStatistics, MEAN).isEqualTo((Object)mean22);
        this.ioStatistics.setMeanStatistic("m2", mean11);
    }
}

