/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.CrcComposer;
import org.apache.hadoop.util.CrcUtil;
import org.apache.hadoop.util.DataChecksum;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestCrcComposer {
    @Rule
    public Timeout globalTimeout = new Timeout(10000L, TimeUnit.MILLISECONDS);
    private Random rand = new Random(1234L);
    private DataChecksum.Type type = DataChecksum.Type.CRC32C;
    private DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)this.type, (int)Integer.MAX_VALUE);
    private int dataSize = 75;
    private byte[] data = new byte[this.dataSize];
    private int chunkSize = 10;
    private int cellSize = 20;
    private int fullCrc;
    private int[] crcsByChunk;
    private int[] crcsByCell;
    private byte[] crcBytesByChunk;
    private byte[] crcBytesByCell;

    @Before
    public void setup() throws IOException {
        int i;
        this.rand.nextBytes(this.data);
        this.fullCrc = this.getRangeChecksum(this.data, 0, this.dataSize);
        this.crcsByChunk = new int[8];
        for (i = 0; i < 7; ++i) {
            this.crcsByChunk[i] = this.getRangeChecksum(this.data, i * this.chunkSize, this.chunkSize);
        }
        this.crcsByChunk[7] = this.getRangeChecksum(this.data, (this.crcsByChunk.length - 1) * this.chunkSize, this.dataSize % this.chunkSize);
        this.crcsByCell = new int[4];
        for (i = 0; i < 3; ++i) {
            this.crcsByCell[i] = this.getRangeChecksum(this.data, i * this.cellSize, this.cellSize);
        }
        this.crcsByCell[3] = this.getRangeChecksum(this.data, (this.crcsByCell.length - 1) * this.cellSize, this.dataSize % this.cellSize);
        this.crcBytesByChunk = this.intArrayToByteArray(this.crcsByChunk);
        this.crcBytesByCell = this.intArrayToByteArray(this.crcsByCell);
    }

    private int getRangeChecksum(byte[] buf, int offset, int length) {
        this.checksum.reset();
        this.checksum.update(buf, offset, length);
        return (int)this.checksum.getValue();
    }

    private byte[] intArrayToByteArray(int[] values) throws IOException {
        byte[] bytes = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            CrcUtil.writeInt((byte[])bytes, (int)(i * 4), (int)values[i]);
        }
        return bytes;
    }

    @Test
    public void testUnstripedIncorrectChunkSize() throws IOException {
        CrcComposer digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)this.chunkSize);
        digester.update(this.crcBytesByChunk, 0, this.crcBytesByChunk.length, (long)this.chunkSize);
        byte[] digest = digester.digest();
        Assert.assertEquals((long)4L, (long)digest.length);
        int calculatedCrc = CrcUtil.readInt((byte[])digest, (int)0);
        Assert.assertNotEquals((long)this.fullCrc, (long)calculatedCrc);
    }

    @Test
    public void testUnstripedByteArray() throws IOException {
        CrcComposer digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)this.chunkSize);
        digester.update(this.crcBytesByChunk, 0, this.crcBytesByChunk.length - 4, (long)this.chunkSize);
        digester.update(this.crcBytesByChunk, this.crcBytesByChunk.length - 4, 4, (long)(this.dataSize % this.chunkSize));
        byte[] digest = digester.digest();
        Assert.assertEquals((long)4L, (long)digest.length);
        int calculatedCrc = CrcUtil.readInt((byte[])digest, (int)0);
        Assert.assertEquals((long)this.fullCrc, (long)calculatedCrc);
    }

    @Test
    public void testUnstripedDataInputStream() throws IOException {
        CrcComposer digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)this.chunkSize);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.crcBytesByChunk));
        digester.update(input, (long)(this.crcsByChunk.length - 1), (long)this.chunkSize);
        digester.update(input, 1L, (long)(this.dataSize % this.chunkSize));
        byte[] digest = digester.digest();
        Assert.assertEquals((long)4L, (long)digest.length);
        int calculatedCrc = CrcUtil.readInt((byte[])digest, (int)0);
        Assert.assertEquals((long)this.fullCrc, (long)calculatedCrc);
    }

    @Test
    public void testUnstripedSingleCrcs() throws IOException {
        CrcComposer digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)this.chunkSize);
        for (int i = 0; i < this.crcsByChunk.length - 1; ++i) {
            digester.update(this.crcsByChunk[i], (long)this.chunkSize);
        }
        digester.update(this.crcsByChunk[this.crcsByChunk.length - 1], (long)(this.dataSize % this.chunkSize));
        byte[] digest = digester.digest();
        Assert.assertEquals((long)4L, (long)digest.length);
        int calculatedCrc = CrcUtil.readInt((byte[])digest, (int)0);
        Assert.assertEquals((long)this.fullCrc, (long)calculatedCrc);
    }

    @Test
    public void testStripedByteArray() throws IOException {
        CrcComposer digester = CrcComposer.newStripedCrcComposer((DataChecksum.Type)this.type, (long)this.chunkSize, (long)this.cellSize);
        digester.update(this.crcBytesByChunk, 0, this.crcBytesByChunk.length - 4, (long)this.chunkSize);
        digester.update(this.crcBytesByChunk, this.crcBytesByChunk.length - 4, 4, (long)(this.dataSize % this.chunkSize));
        byte[] digest = digester.digest();
        Assert.assertArrayEquals((byte[])this.crcBytesByCell, (byte[])digest);
    }

    @Test
    public void testStripedDataInputStream() throws IOException {
        CrcComposer digester = CrcComposer.newStripedCrcComposer((DataChecksum.Type)this.type, (long)this.chunkSize, (long)this.cellSize);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.crcBytesByChunk));
        digester.update(input, (long)(this.crcsByChunk.length - 1), (long)this.chunkSize);
        digester.update(input, 1L, (long)(this.dataSize % this.chunkSize));
        byte[] digest = digester.digest();
        Assert.assertArrayEquals((byte[])this.crcBytesByCell, (byte[])digest);
    }

    @Test
    public void testStripedSingleCrcs() throws IOException {
        CrcComposer digester = CrcComposer.newStripedCrcComposer((DataChecksum.Type)this.type, (long)this.chunkSize, (long)this.cellSize);
        for (int i = 0; i < this.crcsByChunk.length - 1; ++i) {
            digester.update(this.crcsByChunk[i], (long)this.chunkSize);
        }
        digester.update(this.crcsByChunk[this.crcsByChunk.length - 1], (long)(this.dataSize % this.chunkSize));
        byte[] digest = digester.digest();
        Assert.assertArrayEquals((byte[])this.crcBytesByCell, (byte[])digest);
    }

    @Test
    public void testMultiStageMixed() throws IOException {
        CrcComposer digester = CrcComposer.newStripedCrcComposer((DataChecksum.Type)this.type, (long)this.chunkSize, (long)this.cellSize);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.crcBytesByChunk));
        digester.update(input, (long)(this.crcsByChunk.length - 1), (long)this.chunkSize);
        digester.update(input, 1L, (long)(this.dataSize % this.chunkSize));
        byte[] digest = digester.digest();
        digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)this.cellSize);
        for (int i = 0; i < digest.length - 4; i += 4) {
            int cellCrc = CrcUtil.readInt((byte[])digest, (int)i);
            digester.update(cellCrc, (long)this.cellSize);
        }
        digester.update(digest, digest.length - 4, 4, (long)(this.dataSize % this.cellSize));
        digest = digester.digest();
        Assert.assertEquals((long)4L, (long)digest.length);
        int calculatedCrc = CrcUtil.readInt((byte[])digest, (int)0);
        Assert.assertEquals((long)this.fullCrc, (long)calculatedCrc);
    }

    @Test
    public void testUpdateMismatchesStripe() throws Exception {
        CrcComposer digester = CrcComposer.newStripedCrcComposer((DataChecksum.Type)this.type, (long)this.chunkSize, (long)this.cellSize);
        digester.update(this.crcsByChunk[0], (long)this.chunkSize);
        LambdaTestUtils.intercept(IOException.class, "stripe", () -> digester.update(this.crcsByChunk[1], (long)this.cellSize));
    }

    @Test
    public void testUpdateByteArrayLengthUnalignedWithCrcSize() throws Exception {
        CrcComposer digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)this.chunkSize);
        LambdaTestUtils.intercept(IOException.class, "length", () -> digester.update(this.crcBytesByChunk, 0, 6, (long)this.chunkSize));
    }
}

