/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.curator;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.curator.test.InstanceSpec;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.zookeeper.ClientCnxnSocketNetty;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSecureZKCuratorManager {
    public static final boolean DELETE_DATA_DIRECTORY_ON_CLOSE = true;
    private TestingServer server;
    private ZKCuratorManager curator;
    private Configuration hadoopConf;
    static final int SECURE_CLIENT_PORT = 2281;
    static final int JUTE_MAXBUFFER = 400000000;
    static final File ZK_DATA_DIR = new File("testZkSSLClientConnectionDataDir");
    private static final int SERVER_ID = 1;
    private static final int TICK_TIME = 100;
    private static final int MAX_CLIENT_CNXNS = 10;
    public static final int ELECTION_PORT = -1;
    public static final int QUORUM_PORT = -1;

    @Before
    public void setup() throws Exception {
        HashMap<String, Object> customConfiguration = new HashMap<String, Object>();
        customConfiguration.put("secureClientPort", String.valueOf(2281));
        customConfiguration.put("audit.enable", true);
        this.hadoopConf = TestSecureZKCuratorManager.setUpSecureConfig();
        InstanceSpec spec = new InstanceSpec(ZK_DATA_DIR, 2281, -1, -1, true, 1, 100, 10, customConfiguration);
        this.server = new TestingServer(spec, true);
        this.hadoopConf.set("hadoop.zk.address", this.server.getConnectString());
        this.curator = new ZKCuratorManager(this.hadoopConf);
        this.curator.start(new ArrayList(), true);
    }

    public static Configuration setUpSecureConfig() {
        return TestSecureZKCuratorManager.setUpSecureConfig(new Configuration(), "src/test/java/org/apache/hadoop/util/curator/resources/data");
    }

    public static Configuration setUpSecureConfig(Configuration conf, String testDataPath) {
        System.setProperty("zookeeper.serverCnxnFactory", NettyServerCnxnFactory.class.getCanonicalName());
        System.setProperty("zookeeper.ssl.keyStore.location", testDataPath + "keystore.jks");
        System.setProperty("zookeeper.ssl.keyStore.password", "password");
        System.setProperty("zookeeper.ssl.trustStore.location", testDataPath + "truststore.jks");
        System.setProperty("zookeeper.ssl.trustStore.password", "password");
        System.setProperty("zookeeper.request.timeout", "12345");
        System.setProperty("jute.maxbuffer", String.valueOf(400000000));
        System.setProperty("javax.net.debug", "ssl");
        System.setProperty("zookeeper.authProvider.x509", "org.apache.zookeeper.server.auth.X509AuthenticationProvider");
        conf.set("hadoop.zk.ssl.keystore.location", testDataPath + "/ssl/keystore.jks");
        conf.set("hadoop.zk.ssl.keystore.password", "password");
        conf.set("hadoop.zk.ssl.truststore.location", testDataPath + "/ssl/truststore.jks");
        conf.set("hadoop.zk.ssl.truststore.password", "password");
        return conf;
    }

    @After
    public void teardown() throws Exception {
        this.curator.close();
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    @Test
    public void testSecureZKConfiguration() throws Exception {
        FileContext.LOG.info("Entered to the testSecureZKConfiguration test case.");
        ZKCuratorManager.HadoopZookeeperFactory factory = new ZKCuratorManager.HadoopZookeeperFactory(null, null, null, true, new SecurityUtil.TruststoreKeystore(this.hadoopConf));
        ZooKeeper zk = factory.newZooKeeper(this.server.getConnectString(), 1000, null, false);
        this.validateSSLConfiguration(this.hadoopConf.get("hadoop.zk.ssl.keystore.location"), this.hadoopConf.get("hadoop.zk.ssl.keystore.password"), this.hadoopConf.get("hadoop.zk.ssl.truststore.location"), this.hadoopConf.get("hadoop.zk.ssl.truststore.password"), zk);
    }

    private void validateSSLConfiguration(String keystoreLocation, String keystorePassword, String truststoreLocation, String truststorePassword, ZooKeeper zk) {
        try (ClientX509Util x509Util = new ClientX509Util();){
            Assert.assertEquals((String)"Validate that expected clientConfig is set in ZK config", (Object)keystoreLocation, (Object)zk.getClientConfig().getProperty(x509Util.getSslKeystoreLocationProperty()));
            Assert.assertEquals((String)"Validate that expected clientConfig is set in ZK config", (Object)keystorePassword, (Object)zk.getClientConfig().getProperty(x509Util.getSslKeystorePasswdProperty()));
            Assert.assertEquals((String)"Validate that expected clientConfig is set in ZK config", (Object)truststoreLocation, (Object)zk.getClientConfig().getProperty(x509Util.getSslTruststoreLocationProperty()));
            Assert.assertEquals((String)"Validate that expected clientConfig is set in ZK config", (Object)truststorePassword, (Object)zk.getClientConfig().getProperty(x509Util.getSslTruststorePasswdProperty()));
        }
        Assert.assertEquals((String)"Validate that expected clientConfig is set in ZK config", (Object)Boolean.TRUE.toString(), (Object)zk.getClientConfig().getProperty("zookeeper.client.secure"));
        Assert.assertEquals((String)"Validate that expected clientConfig is set in ZK config", (Object)ClientCnxnSocketNetty.class.getCanonicalName(), (Object)zk.getClientConfig().getProperty("zookeeper.clientCnxnSocket"));
    }

    @Test
    public void testTruststoreKeystoreConfiguration() {
        FileContext.LOG.info("Entered to the testTruststoreKeystoreConfiguration test case.");
        Configuration conf = new Configuration();
        SecurityUtil.TruststoreKeystore truststoreKeystore = new SecurityUtil.TruststoreKeystore(conf);
        Assert.assertEquals((String)"Validate that null value is converted to empty string.", (Object)"", (Object)truststoreKeystore.getKeystoreLocation());
        Assert.assertEquals((String)"Validate that null value is converted to empty string.", (Object)"", (Object)truststoreKeystore.getKeystorePassword());
        Assert.assertEquals((String)"Validate that null value is converted to empty string.", (Object)"", (Object)truststoreKeystore.getTruststoreLocation());
        Assert.assertEquals((String)"Validate that null value is converted to empty string.", (Object)"", (Object)truststoreKeystore.getTruststorePassword());
        conf.set("hadoop.zk.ssl.keystore.location", "/keystore.jks");
        conf.set("hadoop.zk.ssl.keystore.password", "keystorePassword");
        conf.set("hadoop.zk.ssl.truststore.location", "/truststore.jks");
        conf.set("hadoop.zk.ssl.truststore.password", "truststorePassword");
        SecurityUtil.TruststoreKeystore truststoreKeystore1 = new SecurityUtil.TruststoreKeystore(conf);
        Assert.assertEquals((String)"Validate that non-null value kept intact.", (Object)"/keystore.jks", (Object)truststoreKeystore1.getKeystoreLocation());
        Assert.assertEquals((String)"Validate that null value is converted to empty string.", (Object)"keystorePassword", (Object)truststoreKeystore1.getKeystorePassword());
        Assert.assertEquals((String)"Validate that null value is converted to empty string.", (Object)"/truststore.jks", (Object)truststoreKeystore1.getTruststoreLocation());
        Assert.assertEquals((String)"Validate that null value is converted to empty string.", (Object)"truststorePassword", (Object)truststoreKeystore1.getTruststorePassword());
    }
}

