/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.proto.ClientAMProtocol;
import org.apache.hadoop.yarn.service.ClientAMPolicyProvider;
import org.apache.hadoop.yarn.service.ClientAMProtocol;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceEvent;
import org.apache.hadoop.yarn.service.ServiceEventType;
import org.apache.hadoop.yarn.service.api.records.ComponentContainers;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.hadoop.yarn.service.exceptions.BadClusterStateException;
import org.apache.hadoop.yarn.service.utils.FilterUtils;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAMService
extends AbstractService
implements ClientAMProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(ClientAMService.class);
    private ServiceContext context;
    private Server server;
    private InetSocketAddress bindAddress;

    public ClientAMService(ServiceContext context) {
        super("Client AM Service");
        this.context = context;
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        String nodeHostString = this.getNMHostName();
        InetSocketAddress address = new InetSocketAddress(nodeHostString, 0);
        this.server = rpc.getServer(ClientAMProtocol.class, (Object)this, address, conf, (SecretManager)this.context.secretManager, 1, "yarn.service.am.client.port-range");
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.server.refreshServiceAcl(this.getConfig(), (PolicyProvider)new ClientAMPolicyProvider());
        }
        this.server.start();
        this.bindAddress = NetUtils.createSocketAddrForHost((String)nodeHostString, (int)this.server.getListenerAddress().getPort());
        LOG.info("Instantiated ClientAMService at " + this.bindAddress);
        super.serviceStart();
    }

    @VisibleForTesting
    String getNMHostName() throws BadClusterStateException {
        return ServiceUtils.mandatoryEnvVariable(ApplicationConstants.Environment.NM_HOST.name());
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    @Override
    public ClientAMProtocol.FlexComponentsResponseProto flexComponents(ClientAMProtocol.FlexComponentsRequestProto request) throws IOException {
        if (!request.getComponentsList().isEmpty()) {
            for (ClientAMProtocol.ComponentCountProto component : request.getComponentsList()) {
                ComponentEvent event = new ComponentEvent(component.getName(), ComponentEventType.FLEX).setDesired(component.getNumberOfContainers());
                this.context.scheduler.getDispatcher().getEventHandler().handle((Event)event);
                LOG.info("Flexing component {} to {}", (Object)component.getName(), (Object)component.getNumberOfContainers());
            }
        }
        return ClientAMProtocol.FlexComponentsResponseProto.newBuilder().build();
    }

    @Override
    public ClientAMProtocol.GetStatusResponseProto getStatus(ClientAMProtocol.GetStatusRequestProto request) throws IOException, YarnException {
        String stat = ServiceApiUtil.jsonSerDeser.toJson(this.context.service);
        return ClientAMProtocol.GetStatusResponseProto.newBuilder().setStatus(stat).build();
    }

    @Override
    public ClientAMProtocol.StopResponseProto stop(ClientAMProtocol.StopRequestProto requestProto) throws IOException, YarnException {
        LOG.info("Stop the service by {}", (Object)UserGroupInformation.getCurrentUser());
        this.context.scheduler.getDiagnostics().append((CharSequence)("Stopped by user " + UserGroupInformation.getCurrentUser()));
        this.context.scheduler.setGracefulStop(FinalApplicationStatus.ENDED);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    ExitUtil.terminate((int)0);
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted while stopping", (Throwable)e);
                }
            }
        };
        thread.start();
        return ClientAMProtocol.StopResponseProto.newBuilder().build();
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public ClientAMProtocol.UpgradeServiceResponseProto upgrade(ClientAMProtocol.UpgradeServiceRequestProto request) throws IOException {
        try {
            LOG.info("Upgrading service to version {} by {}", (Object)request.getVersion(), (Object)UserGroupInformation.getCurrentUser());
            this.context.getServiceManager().processUpgradeRequest(request.getVersion(), request.getAutoFinalize(), request.getExpressUpgrade());
            return ClientAMProtocol.UpgradeServiceResponseProto.newBuilder().build();
        }
        catch (Exception ex) {
            return ClientAMProtocol.UpgradeServiceResponseProto.newBuilder().setError(ex.getMessage()).build();
        }
    }

    @Override
    public ClientAMProtocol.RestartServiceResponseProto restart(ClientAMProtocol.RestartServiceRequestProto request) throws IOException, YarnException {
        ServiceEvent event = new ServiceEvent(ServiceEventType.START);
        this.context.scheduler.getDispatcher().getEventHandler().handle((Event)event);
        LOG.info("Restart service by {}", (Object)UserGroupInformation.getCurrentUser());
        return ClientAMProtocol.RestartServiceResponseProto.newBuilder().build();
    }

    @Override
    public ClientAMProtocol.CompInstancesUpgradeResponseProto upgrade(ClientAMProtocol.CompInstancesUpgradeRequestProto request) throws IOException, YarnException {
        if (!request.getContainerIdsList().isEmpty()) {
            for (String containerId : request.getContainerIdsList()) {
                ComponentInstanceEvent event = new ComponentInstanceEvent(ContainerId.fromString((String)containerId), ComponentInstanceEventType.UPGRADE);
                LOG.info("Upgrade container {}", (Object)containerId);
                this.context.scheduler.getDispatcher().getEventHandler().handle((Event)event);
            }
        }
        return ClientAMProtocol.CompInstancesUpgradeResponseProto.newBuilder().build();
    }

    @Override
    public ClientAMProtocol.GetCompInstancesResponseProto getCompInstances(ClientAMProtocol.GetCompInstancesRequestProto request) throws IOException {
        List<ComponentContainers> containers = FilterUtils.filterInstances(this.context, request);
        return ClientAMProtocol.GetCompInstancesResponseProto.newBuilder().setCompInstances(ServiceApiUtil.COMP_CONTAINERS_JSON_SERDE.toJson(containers.toArray(new ComponentContainers[containers.size()]))).build();
    }

    @Override
    public ClientAMProtocol.CancelUpgradeResponseProto cancelUpgrade(ClientAMProtocol.CancelUpgradeRequestProto request) throws IOException, YarnException {
        LOG.info("Cancel service upgrade by {}", (Object)UserGroupInformation.getCurrentUser());
        ServiceEvent event = new ServiceEvent(ServiceEventType.CANCEL_UPGRADE);
        this.context.scheduler.getDispatcher().getEventHandler().handle((Event)event);
        return ClientAMProtocol.CancelUpgradeResponseProto.newBuilder().build();
    }

    @Override
    public ClientAMProtocol.DecommissionCompInstancesResponseProto decommissionCompInstances(ClientAMProtocol.DecommissionCompInstancesRequestProto request) throws IOException, YarnException {
        if (!request.getCompInstancesList().isEmpty()) {
            for (String instance : request.getCompInstancesList()) {
                String componentName = ServiceApiUtil.parseComponentName(instance);
                ComponentEvent event = new ComponentEvent(componentName, ComponentEventType.DECOMMISSION_INSTANCE).setInstanceName(instance);
                this.context.scheduler.getDispatcher().getEventHandler().handle((Event)event);
                LOG.info("Decommissioning component {} instance {}", (Object)componentName, (Object)instance);
            }
        }
        return ClientAMProtocol.DecommissionCompInstancesResponseProto.newBuilder().build();
    }
}

