/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component;

import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.ComponentRestartPolicy;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;

public final class AlwaysRestartPolicy
implements ComponentRestartPolicy {
    private static AlwaysRestartPolicy INSTANCE = new AlwaysRestartPolicy();

    private AlwaysRestartPolicy() {
    }

    public static AlwaysRestartPolicy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isLongLived() {
        return true;
    }

    @Override
    public boolean hasCompleted(Component component) {
        return false;
    }

    @Override
    public boolean hasCompletedSuccessfully(Component component) {
        return false;
    }

    @Override
    public boolean shouldRelaunchInstance(ComponentInstance componentInstance, ContainerStatus containerStatus) {
        return true;
    }

    @Override
    public boolean isReadyForDownStream(Component dependentComponent) {
        return dependentComponent.getNumReadyInstances() >= dependentComponent.getNumDesiredInstances();
    }

    @Override
    public boolean allowUpgrades() {
        return true;
    }

    @Override
    public boolean shouldTerminate(Component component) {
        return false;
    }

    @Override
    public boolean allowContainerRetriesForInstance(ComponentInstance componentInstance) {
        return true;
    }
}

