/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreOperationResult;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.hdfs.server.federation.store.records.QueryResult;
import org.apache.hadoop.io.retry.AtMostOnce;
import org.apache.hadoop.io.retry.Idempotent;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface StateStoreRecordOperations {
    @Idempotent
    public <T extends BaseRecord> QueryResult<T> get(Class<T> var1) throws IOException;

    @Idempotent
    public <T extends BaseRecord> T get(Class<T> var1, Query<T> var2) throws IOException;

    @Idempotent
    public <T extends BaseRecord> List<T> getMultiple(Class<T> var1, Query<T> var2) throws IOException;

    @AtMostOnce
    public <T extends BaseRecord> boolean put(T var1, boolean var2, boolean var3) throws IOException;

    @AtMostOnce
    public <T extends BaseRecord> StateStoreOperationResult putAll(List<T> var1, boolean var2, boolean var3) throws IOException;

    @AtMostOnce
    public <T extends BaseRecord> boolean remove(T var1) throws IOException;

    @AtMostOnce
    public <T extends BaseRecord> boolean removeAll(Class<T> var1) throws IOException;

    @AtMostOnce
    public <T extends BaseRecord> int remove(Class<T> var1, Query<T> var2) throws IOException;
}

