/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.router.DFSRouter;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterStateIdContext;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSRouter {
    @Test
    public void testDefaultConfigs() {
        Configuration configuration = DFSRouter.getConfiguration();
        String journalUri = configuration.get("hdfs.fedbalance.procedure.scheduler.journal.uri");
        int workerThreads = configuration.getInt("hdfs.fedbalance.procedure.work.thread.num", -1);
        Assert.assertEquals((Object)"hdfs://localhost:8020/tmp/procedure", (Object)journalUri);
        Assert.assertEquals((long)10L, (long)workerThreads);
    }

    @Test
    public void testClearStaleNamespacesInRouterStateIdContext() throws Exception {
        Router testRouter = new Router();
        Configuration routerConfig = DFSRouter.getConfiguration();
        routerConfig.set("dfs.federation.router.store.membership.expiration", "2000");
        routerConfig.set("dfs.federation.router.safemode.enable", "false");
        routerConfig.setClass("dfs.federation.router.namenode.resolver.client.class", MockResolver.class, ActiveNamenodeResolver.class);
        routerConfig.setClass("dfs.federation.router.file.resolver.client.class", MockResolver.class, FileSubclusterResolver.class);
        testRouter.init(routerConfig);
        String nsID1 = "ns0";
        String nsID2 = "ns1";
        MockResolver resolver = (MockResolver)testRouter.getNamenodeResolver();
        resolver.registerNamenode(FederationTestUtils.createNamenodeReport(nsID1, "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        resolver.registerNamenode(FederationTestUtils.createNamenodeReport(nsID2, "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        RouterRpcServer rpcServer = testRouter.getRpcServer();
        rpcServer.getRouterStateIdContext().getNamespaceStateId(nsID1);
        rpcServer.getRouterStateIdContext().getNamespaceStateId(nsID2);
        resolver.disableNamespace(nsID1);
        Thread.sleep(3000L);
        RouterStateIdContext context = rpcServer.getRouterStateIdContext();
        Assert.assertEquals((long)2L, (long)context.getNamespaceIdMap().size());
        testRouter.start();
        Thread.sleep(3000L);
        RouterStateIdContext routerStateIdContext = rpcServer.getRouterStateIdContext();
        int size = routerStateIdContext.getNamespaceIdMap().size();
        Assert.assertEquals((long)1L, (long)size);
        rpcServer.stop();
        rpcServer.close();
        testRouter.close();
    }
}

