/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.codemodel;

import org.apache.hadoop.shaded.com.sun.codemodel.JClass;
import org.apache.hadoop.shaded.com.sun.codemodel.JCodeModel;
import org.apache.hadoop.shaded.com.sun.codemodel.JGenerable;
import org.apache.hadoop.shaded.com.sun.codemodel.JPrimitiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JType
implements JGenerable,
Comparable<JType> {
    public static JPrimitiveType parse(JCodeModel codeModel, String typeName) {
        if (typeName.equals("void")) {
            return codeModel.VOID;
        }
        if (typeName.equals("boolean")) {
            return codeModel.BOOLEAN;
        }
        if (typeName.equals("byte")) {
            return codeModel.BYTE;
        }
        if (typeName.equals("short")) {
            return codeModel.SHORT;
        }
        if (typeName.equals("char")) {
            return codeModel.CHAR;
        }
        if (typeName.equals("int")) {
            return codeModel.INT;
        }
        if (typeName.equals("float")) {
            return codeModel.FLOAT;
        }
        if (typeName.equals("long")) {
            return codeModel.LONG;
        }
        if (typeName.equals("double")) {
            return codeModel.DOUBLE;
        }
        throw new IllegalArgumentException("Not a primitive type: " + typeName);
    }

    public abstract JCodeModel owner();

    public abstract String fullName();

    public String binaryName() {
        return this.fullName();
    }

    public abstract String name();

    public abstract JClass array();

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public abstract JClass boxify();

    public abstract JType unboxify();

    public JType erasure() {
        return this;
    }

    public final boolean isReference() {
        return !this.isPrimitive();
    }

    public JType elementType() {
        throw new IllegalArgumentException("Not an array type");
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.fullName() + ')';
    }

    @Override
    public int compareTo(JType o) {
        String rhs = o.fullName();
        boolean p = this.fullName().startsWith("java");
        boolean q = rhs.startsWith("java");
        if (p && !q) {
            return -1;
        }
        if (!p && q) {
            return 1;
        }
        return this.fullName().compareTo(rhs);
    }
}

