/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.io.netty.resolver.dns;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.shaded.io.netty.util.internal.BoundedInputStream;

final class ResolvConf {
    private final List<InetSocketAddress> nameservers;

    static ResolvConf fromReader(BufferedReader reader) throws IOException {
        return new ResolvConf(reader);
    }

    static ResolvConf fromFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new BoundedInputStream(new FileInputStream(file), 0x100000)));
        try {
            ResolvConf resolvConf = ResolvConf.fromReader(reader);
            return resolvConf;
        }
        finally {
            reader.close();
        }
    }

    static ResolvConf system() {
        ResolvConf resolvConv = ResolvConfLazy.machineResolvConf;
        if (resolvConv != null) {
            return resolvConv;
        }
        throw new IllegalStateException("/etc/resolv.conf could not be read");
    }

    private ResolvConf(BufferedReader reader) throws IOException {
        String ln;
        ArrayList<InetSocketAddress> nameservers = new ArrayList<InetSocketAddress>();
        while ((ln = reader.readLine()) != null) {
            if ((ln = ln.trim()).isEmpty() || !ln.startsWith("nameserver")) continue;
            int cIndex = (ln = ln.substring("nameserver".length())).indexOf(35);
            if (cIndex != -1) {
                ln = ln.substring(0, cIndex);
            }
            if ((ln = ln.trim()).isEmpty()) continue;
            nameservers.add(new InetSocketAddress(ln, 53));
        }
        this.nameservers = Collections.unmodifiableList(nameservers);
    }

    List<InetSocketAddress> getNameservers() {
        return this.nameservers;
    }

    private static final class ResolvConfLazy {
        static final ResolvConf machineResolvConf;

        private ResolvConfLazy() {
        }

        static {
            ResolvConf resolvConf;
            try {
                resolvConf = ResolvConf.fromFile("/etc/resolv.conf");
            }
            catch (IOException e) {
                resolvConf = null;
            }
            catch (SecurityException ignore) {
                resolvConf = null;
            }
            machineResolvConf = resolvConf;
        }
    }
}

