/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.config.resilience;

import org.apache.hadoop.shaded.org.ehcache.impl.config.resilience.DefaultResilienceStrategyConfiguration;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.classes.ClassInstanceProviderConfiguration;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.resilience.RobustLoaderWriterResilienceStrategy;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.resilience.RobustResilienceStrategy;
import org.apache.hadoop.shaded.org.ehcache.spi.resilience.ResilienceStrategy;
import org.apache.hadoop.shaded.org.ehcache.spi.resilience.ResilienceStrategyProvider;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceCreationConfiguration;

public class DefaultResilienceStrategyProviderConfiguration
extends ClassInstanceProviderConfiguration<String, DefaultResilienceStrategyConfiguration>
implements ServiceCreationConfiguration<ResilienceStrategyProvider, DefaultResilienceStrategyProviderConfiguration> {
    private static final Class<? extends ResilienceStrategy> DEFAULT_RESILIENCE = RobustResilienceStrategy.class;
    private static final Class<? extends ResilienceStrategy> DEFAULT_LOADER_WRITER_RESILIENCE = RobustLoaderWriterResilienceStrategy.class;
    private DefaultResilienceStrategyConfiguration defaultRegularConfiguration;
    private DefaultResilienceStrategyConfiguration defaultLoaderWriterConfiguration;

    private DefaultResilienceStrategyProviderConfiguration(DefaultResilienceStrategyProviderConfiguration config) {
        super(config);
        this.defaultRegularConfiguration = config.defaultRegularConfiguration;
        this.defaultLoaderWriterConfiguration = config.defaultLoaderWriterConfiguration;
    }

    public DefaultResilienceStrategyProviderConfiguration() {
        this.defaultRegularConfiguration = new DefaultResilienceStrategyConfiguration(DEFAULT_RESILIENCE, new Object[0]);
        this.defaultLoaderWriterConfiguration = new DefaultResilienceStrategyConfiguration(DEFAULT_LOADER_WRITER_RESILIENCE, new Object[0]);
    }

    public DefaultResilienceStrategyConfiguration getDefaultConfiguration() {
        return this.defaultRegularConfiguration;
    }

    public DefaultResilienceStrategyConfiguration getDefaultLoaderWriterConfiguration() {
        return this.defaultLoaderWriterConfiguration;
    }

    @Override
    public Class<ResilienceStrategyProvider> getServiceType() {
        return ResilienceStrategyProvider.class;
    }

    public DefaultResilienceStrategyProviderConfiguration setDefaultResilienceStrategy(Class<? extends ResilienceStrategy> clazz, Object ... arguments) {
        this.defaultRegularConfiguration = new DefaultResilienceStrategyConfiguration(clazz, arguments);
        return this;
    }

    public DefaultResilienceStrategyProviderConfiguration setDefaultResilienceStrategy(ResilienceStrategy<?, ?> resilienceStrategy) {
        this.defaultRegularConfiguration = new DefaultResilienceStrategyConfiguration(resilienceStrategy);
        return this;
    }

    public DefaultResilienceStrategyProviderConfiguration setDefaultLoaderWriterResilienceStrategy(Class<? extends ResilienceStrategy> clazz, Object ... arguments) {
        this.defaultLoaderWriterConfiguration = new DefaultResilienceStrategyConfiguration(clazz, arguments);
        return this;
    }

    public DefaultResilienceStrategyProviderConfiguration setDefaultLoaderWriterResilienceStrategy(ResilienceStrategy<?, ?> resilienceStrategy) {
        this.defaultLoaderWriterConfiguration = new DefaultResilienceStrategyConfiguration(resilienceStrategy);
        return this;
    }

    public DefaultResilienceStrategyProviderConfiguration addResilienceStrategyFor(String alias, Class<? extends ResilienceStrategy> clazz, Object ... arguments) {
        this.getDefaults().put(alias, new DefaultResilienceStrategyConfiguration(clazz, arguments));
        return this;
    }

    public DefaultResilienceStrategyProviderConfiguration addResilienceStrategyFor(String alias, ResilienceStrategy<?, ?> resilienceStrategy) {
        this.getDefaults().put(alias, new DefaultResilienceStrategyConfiguration(resilienceStrategy));
        return this;
    }

    @Override
    public DefaultResilienceStrategyProviderConfiguration derive() {
        return new DefaultResilienceStrategyProviderConfiguration(this);
    }

    public DefaultResilienceStrategyProviderConfiguration build(DefaultResilienceStrategyProviderConfiguration configuration) {
        return configuration;
    }
}

