/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.jsr107;

import java.net.URI;
import org.apache.hadoop.shaded.javax.cache.management.CacheStatisticsMXBean;
import org.apache.hadoop.shaded.org.ehcache.core.spi.service.StatisticsService;
import org.apache.hadoop.shaded.org.ehcache.core.statistics.CacheOperationOutcomes;
import org.apache.hadoop.shaded.org.ehcache.core.statistics.CacheStatistics;
import org.apache.hadoop.shaded.org.ehcache.core.statistics.Jsr107LatencyMonitor;
import org.apache.hadoop.shaded.org.ehcache.jsr107.Eh107MXBean;

class Eh107CacheStatisticsMXBean
extends Eh107MXBean
implements CacheStatisticsMXBean {
    private final CacheStatistics cacheStatistics;
    private final Jsr107LatencyMonitor<CacheOperationOutcomes.GetOutcome> averageGetTime;
    private final Jsr107LatencyMonitor<CacheOperationOutcomes.PutOutcome> averagePutTime;
    private final Jsr107LatencyMonitor<CacheOperationOutcomes.RemoveOutcome> averageRemoveTime;

    Eh107CacheStatisticsMXBean(String cacheName, URI cacheManagerURI, StatisticsService statisticsService) {
        super(cacheName, cacheManagerURI, "CacheStatistics");
        this.cacheStatistics = statisticsService.getCacheStatistics(cacheName);
        this.averageGetTime = this.registerDerivedStatistics(CacheOperationOutcomes.GetOutcome.class, "get");
        this.averagePutTime = this.registerDerivedStatistics(CacheOperationOutcomes.PutOutcome.class, "put");
        this.averageRemoveTime = this.registerDerivedStatistics(CacheOperationOutcomes.RemoveOutcome.class, "remove");
    }

    private <T extends Enum<T>> Jsr107LatencyMonitor<T> registerDerivedStatistics(Class<T> outcome, String name) {
        Jsr107LatencyMonitor<T> monitor = new Jsr107LatencyMonitor<T>(outcome);
        CacheStatistics cacheStatistics = this.cacheStatistics;
        cacheStatistics.registerDerivedStatistic(outcome, name, monitor);
        return monitor;
    }

    @Override
    public void clear() {
        this.cacheStatistics.clear();
        this.averageGetTime.clear();
        this.averagePutTime.clear();
        this.averageRemoveTime.clear();
    }

    @Override
    public long getCacheHits() {
        return this.cacheStatistics.getCacheHits();
    }

    @Override
    public float getCacheHitPercentage() {
        return this.cacheStatistics.getCacheHitPercentage();
    }

    @Override
    public long getCacheMisses() {
        return this.cacheStatistics.getCacheMisses();
    }

    @Override
    public float getCacheMissPercentage() {
        return this.cacheStatistics.getCacheMissPercentage();
    }

    @Override
    public long getCacheGets() {
        return this.cacheStatistics.getCacheGets();
    }

    @Override
    public long getCachePuts() {
        return this.cacheStatistics.getCachePuts();
    }

    @Override
    public long getCacheRemovals() {
        return this.cacheStatistics.getCacheRemovals();
    }

    @Override
    public long getCacheEvictions() {
        return this.cacheStatistics.getCacheEvictions();
    }

    @Override
    public float getAverageGetTime() {
        return (float)this.averageGetTime.average();
    }

    @Override
    public float getAveragePutTime() {
        return (float)this.averagePutTime.average();
    }

    @Override
    public float getAverageRemoveTime() {
        return (float)this.averageRemoveTime.average();
    }
}

