/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.BufferChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.CharChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.DataChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.HexUtils;

public class URLDecoder {
    public static void decode(DataChunk dataChunk) throws CharConversionException {
        URLDecoder.decode(dataChunk, true);
    }

    public static void decode(DataChunk dataChunk, boolean allowEncodedSlash) throws CharConversionException {
        URLDecoder.decode(dataChunk, dataChunk, allowEncodedSlash);
    }

    public static void decode(DataChunk srcDataChunk, DataChunk dstDataChunk, boolean allowEncodedSlash) throws CharConversionException {
        switch (srcDataChunk.getType()) {
            case Buffer: {
                BufferChunk srcBufferChunk = srcDataChunk.getBufferChunk();
                BufferChunk dstBufferChunk = dstDataChunk.getBufferChunk();
                if (dstBufferChunk != srcBufferChunk) {
                    dstBufferChunk.allocate(srcBufferChunk.getLength());
                }
                URLDecoder.decode(srcBufferChunk, dstBufferChunk, allowEncodedSlash);
                return;
            }
            case String: {
                dstDataChunk.setString(URLDecoder.decode(srcDataChunk.toString(), allowEncodedSlash));
                return;
            }
            case Chars: {
                CharChunk srcCharChunk = srcDataChunk.getCharChunk();
                CharChunk dstCharChunk = dstDataChunk.getCharChunk();
                dstCharChunk.ensureCapacity(srcCharChunk.getLength());
                URLDecoder.decode(srcCharChunk, dstCharChunk, allowEncodedSlash);
                dstDataChunk.setChars(dstCharChunk.getChars(), dstCharChunk.getStart(), dstCharChunk.getEnd());
                return;
            }
        }
        throw new NullPointerException();
    }

    public static void decode(BufferChunk bufferChunk, boolean allowEncodedSlash) throws CharConversionException {
        URLDecoder.decode(bufferChunk, bufferChunk, allowEncodedSlash);
    }

    public static void decode(BufferChunk srcBufferChunk, BufferChunk dstBufferChunk, boolean allowEncodedSlash) throws CharConversionException {
        Buffer srcBuffer = srcBufferChunk.getBuffer();
        int srcStart = srcBufferChunk.getStart();
        int srcEnd = srcBufferChunk.getEnd();
        Buffer dstBuffer = dstBufferChunk.getBuffer();
        int idx = dstBufferChunk.getStart();
        int j = srcStart;
        while (j < srcEnd) {
            byte b = srcBuffer.get(j);
            if (b == 43) {
                dstBuffer.put(idx, (byte)32);
            } else if (b != 37) {
                dstBuffer.put(idx, b);
            } else {
                if (j + 2 >= srcEnd) {
                    throw new IllegalStateException("Unexpected termination");
                }
                byte b1 = srcBuffer.get(j + 1);
                byte b2 = srcBuffer.get(j + 2);
                if (!HexUtils.isHexDigit(b1) || !HexUtils.isHexDigit(b2)) {
                    throw new IllegalStateException("isHexDigit");
                }
                j += 2;
                int res = URLDecoder.x2c(b1, b2);
                if (!allowEncodedSlash && res == 47) {
                    throw new CharConversionException("Encoded slashes are not allowed");
                }
                dstBuffer.put(idx, (byte)res);
            }
            ++j;
            ++idx;
        }
        dstBufferChunk.setEnd(idx);
    }

    public static void decode(CharChunk charChunk, boolean allowEncodedSlash) throws CharConversionException {
        URLDecoder.decode(charChunk, charChunk, allowEncodedSlash);
    }

    public static void decode(CharChunk srcCharChunk, CharChunk dstCharChunk, boolean allowEncodedSlash) throws CharConversionException {
        char[] srcBuffer = srcCharChunk.getBuffer();
        int srcStart = srcCharChunk.getStart();
        int srcEnd = srcCharChunk.getEnd();
        char[] dstBuffer = dstCharChunk.getBuffer();
        int idx = dstCharChunk.getStart();
        int j = srcStart;
        while (j < srcEnd) {
            char c = srcBuffer[j];
            if (c == '+') {
                dstBuffer[idx] = 32;
            } else if (c != '%') {
                dstBuffer[idx] = c;
            } else {
                if (j + 2 >= srcEnd) {
                    throw new IllegalStateException("Unexpected termination");
                }
                char c1 = srcBuffer[j + 1];
                char c2 = srcBuffer[j + 2];
                if (!HexUtils.isHexDigit(c1) || !HexUtils.isHexDigit(c2)) {
                    throw new IllegalStateException("isHexDigit");
                }
                j += 2;
                int res = URLDecoder.x2c(c1, c2);
                if (!allowEncodedSlash && res == 47) {
                    throw new CharConversionException("Encoded slashes are not allowed");
                }
                dstBuffer[idx] = (char)res;
            }
            ++j;
            ++idx;
        }
        dstCharChunk.setEnd(idx);
    }

    public static String decode(String str) throws CharConversionException {
        return URLDecoder.decode(str, true);
    }

    public static String decode(String str, boolean allowEncodedSlash) throws CharConversionException {
        if (str == null) {
            return null;
        }
        int strPos = str.indexOf(37);
        if (strPos < 0) {
            return str;
        }
        int strLen = str.length();
        StringBuilder dec = new StringBuilder(strLen);
        while (strPos < strLen) {
            char laChar;
            int laPos;
            for (laPos = strPos; laPos < strLen && (laChar = str.charAt(laPos)) != '%'; ++laPos) {
            }
            if (laPos > strPos) {
                dec.append(str.substring(strPos, laPos));
                strPos = laPos;
            }
            if (strPos >= strLen) break;
            char metaChar = str.charAt(strPos);
            if (metaChar == '+') {
                dec.append(' ');
                ++strPos;
                continue;
            }
            if (metaChar != '%') continue;
            char res = (char)Integer.parseInt(str.substring(strPos + 1, strPos + 3), 16);
            if (!allowEncodedSlash && res == '/') {
                throw new CharConversionException("Encoded slashes are not allowed");
            }
            dec.append(res);
            strPos += 3;
        }
        return dec.toString();
    }

    private static int x2c(byte b1, byte b2) {
        return (HexUtils.hexDigit2Dec(b1) << 4) + HexUtils.hexDigit2Dec(b2);
    }

    private static int x2c(int c1, int c2) {
        return (HexUtils.hexDigit2Dec(c1) << 4) + HexUtils.hexDigit2Dec(c2);
    }
}

