/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.com.nec;

import org.apache.hadoop.shaded.com.sun.jna.Native;
import org.apache.hadoop.shaded.com.sun.jna.Pointer;

class UdevUtil {
    private static LibUdev libUdev;

    UdevUtil() {
    }

    public synchronized void init() {
        LibUdev.init();
        libUdev = LibUdev.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSysPath(int deviceNo, char devType) {
        String string;
        Pointer udev;
        block7: {
            udev = null;
            Pointer device = null;
            try {
                udev = libUdev.udev_new();
                device = libUdev.udev_device_new_from_devnum(udev, (byte)devType, deviceNo);
                if (device == null) {
                    throw new IllegalArgumentException("Udev: device not found");
                }
                Pointer sysPathPtr = libUdev.udev_device_get_syspath(device);
                if (sysPathPtr == null) {
                    throw new IllegalArgumentException("Udev: syspath not found for device");
                }
                string = sysPathPtr.getString(0L);
                if (device == null) break block7;
                libUdev.udev_device_unref(device);
            }
            catch (Throwable throwable) {
                if (device != null) {
                    libUdev.udev_device_unref(device);
                }
                if (udev != null) {
                    libUdev.udev_unref(udev);
                }
                throw throwable;
            }
        }
        if (udev != null) {
            libUdev.udev_unref(udev);
        }
        return string;
    }

    static interface LibUdevMapping {
        public Pointer udev_new();

        public Pointer udev_unref(Pointer var1);

        public Pointer udev_device_new_from_devnum(Pointer var1, byte var2, int var3);

        public Pointer udev_device_get_syspath(Pointer var1);

        public Pointer udev_device_unref(Pointer var1);
    }

    private static class LibUdev
    implements LibUdevMapping {
        private static LibUdev instance;

        private LibUdev() {
        }

        public static void init() {
            if (instance == null) {
                Native.register("udev");
                instance = new LibUdev();
            }
        }

        @Override
        public native Pointer udev_new();

        @Override
        public native Pointer udev_unref(Pointer var1);

        @Override
        public native Pointer udev_device_new_from_devnum(Pointer var1, byte var2, int var3);

        @Override
        public native Pointer udev_device_get_syspath(Pointer var1);

        @Override
        public native Pointer udev_device_unref(Pointer var1);
    }
}

